/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.launcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class TaskLaunchRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uri;
    private List<String> commandlineArguments;
    private Map<String, String> environmentProperties;
    private Map<String, String> deploymentProperties;

    public TaskLaunchRequest(String uri, List<String> commandlineArguments, Map<String, String> environmentProperties, Map<String, String> deploymentProperties) {
        Assert.hasText((String)uri, (String)"uri must not be empty nor null.");
        this.uri = uri;
        this.commandlineArguments = commandlineArguments == null ? new ArrayList() : commandlineArguments;
        this.environmentProperties = environmentProperties == null ? new HashMap() : environmentProperties;
        this.deploymentProperties = deploymentProperties == null ? new HashMap() : deploymentProperties;
    }

    public String getUri() {
        return this.uri;
    }

    public List<String> getCommandlineArguments() {
        return Collections.unmodifiableList(this.commandlineArguments);
    }

    public Map<String, String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String toString() {
        return "TaskLaunchRequest{uri='" + this.uri + '\'' + ", commandlineArguments=" + this.commandlineArguments + ", environmentProperties=" + this.environmentProperties + ", deploymentProperties=" + this.deploymentProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLaunchRequest that = (TaskLaunchRequest)o;
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        if (!(this.commandlineArguments == null ? that.commandlineArguments == null : this.commandlineArguments.equals(that.commandlineArguments))) {
            return false;
        }
        if (!(this.deploymentProperties == null ? that.deploymentProperties == null : this.deploymentProperties.equals(that.deploymentProperties))) {
            return false;
        }
        return this.environmentProperties != null ? this.environmentProperties.equals(that.environmentProperties) : that.environmentProperties == null;
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.commandlineArguments != null ? this.commandlineArguments.hashCode() : 0);
        result = 31 * result + (this.environmentProperties != null ? this.environmentProperties.hashCode() : 0);
        result = 31 * result + (this.deploymentProperties != null ? this.deploymentProperties.hashCode() : 0);
        return result;
    }
}

