/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;

class GenericSecretBackendMetadata
implements SecretBackendMetadata {
    private final String secretBackendPath;
    private final String key;

    private GenericSecretBackendMetadata(String secretBackendPath, String key) {
        Assert.hasText((String)secretBackendPath, (String)"Secret backend path must not be empty");
        Assert.hasText((String)key, (String)"Key must not be empty");
        this.key = key;
        this.secretBackendPath = secretBackendPath;
    }

    public static SecretBackendMetadata create(String secretBackendPath, String key) {
        return new GenericSecretBackendMetadata(secretBackendPath, key);
    }

    @Override
    public String getName() {
        return String.format("%s/%s", this.secretBackendPath, this.key);
    }

    @Override
    public PropertyTransformer getPropertyTransformer() {
        return PropertyTransformers.noop();
    }

    @Override
    public Map<String, String> getVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("backend", this.secretBackendPath);
        variables.put("key", this.key);
        return variables;
    }

    public static List<String> buildContexts(VaultGenericBackendProperties genericBackendProperties, Environment environment) {
        String appName = genericBackendProperties.getApplicationName();
        List<String> profiles = Arrays.asList(environment.getActiveProfiles());
        ArrayList<String> contexts = new ArrayList<String>();
        String defaultContext = genericBackendProperties.getDefaultContext();
        GenericSecretBackendMetadata.addContext(contexts, defaultContext, profiles, genericBackendProperties);
        for (String applicationName : StringUtils.commaDelimitedListToSet((String)appName)) {
            GenericSecretBackendMetadata.addContext(contexts, applicationName, profiles, genericBackendProperties);
        }
        Collections.reverse(contexts);
        return contexts;
    }

    private static void addContext(List<String> contexts, String applicationName, List<String> profiles, VaultGenericBackendProperties genericBackendProperties) {
        if (!StringUtils.hasText((String)applicationName)) {
            return;
        }
        if (!contexts.contains(applicationName)) {
            contexts.add(applicationName);
        }
        for (String profile : profiles) {
            String contextName;
            if (!StringUtils.hasText((String)profile) || contexts.contains(contextName = applicationName + genericBackendProperties.getProfileSeparator() + profile.trim())) continue;
            contexts.add(contextName);
        }
    }
}

