/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocatorSupport;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.env.LeaseAwareVaultPropertySource;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.lease.event.LeaseErrorListener;
import org.springframework.vault.core.lease.event.SecretLeaseEvent;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

class LeasingVaultPropertySourceLocator
extends VaultPropertySourceLocatorSupport
implements PriorityOrdered {
    private static final Log log = LogFactory.getLog(LeasingVaultPropertySourceLocator.class);
    private static final UriTemplateHandler TEMPLATE_HANDLER = new DefaultUriTemplateHandler();
    private final SecretLeaseContainer secretLeaseContainer;
    private final VaultProperties properties;

    public LeasingVaultPropertySourceLocator(VaultProperties properties, VaultGenericBackendProperties genericBackendProperties, Collection<SecretBackendMetadata> backendAccessors, SecretLeaseContainer secretLeaseContainer) {
        super("vault", genericBackendProperties, backendAccessors);
        Assert.notNull((Object)secretLeaseContainer, (String)"SecretLeaseContainer must not be null");
        Assert.notNull((Object)properties, (String)"VaultProperties must not be null");
        this.secretLeaseContainer = secretLeaseContainer;
        this.properties = properties;
    }

    public int getOrder() {
        return this.properties.getConfig().getOrder();
    }

    @Override
    protected PropertySource<?> createVaultPropertySource(SecretBackendMetadata accessor) {
        URI expand = TEMPLATE_HANDLER.expand("{backend}/{key}", accessor.getVariables());
        RequestedSecret secret = RequestedSecret.renewable((String)expand.getPath());
        if (this.properties.isFailFast()) {
            return this.createVaultPropertySourceFailFast(secret, accessor);
        }
        return this.createVaultPropertySource(secret, accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySource<?> createVaultPropertySourceFailFast(final RequestedSecret secret, SecretBackendMetadata accessor) {
        PropertySource<?> propertySource;
        final AtomicReference errorRef = new AtomicReference();
        LeaseErrorListener errorListener = new LeaseErrorListener(){

            public void onLeaseError(SecretLeaseEvent leaseEvent, Exception exception) {
                if (leaseEvent.getSource() == secret) {
                    errorRef.compareAndSet(null, exception);
                }
            }
        };
        this.secretLeaseContainer.addErrorListener(errorListener);
        try {
            propertySource = this.createVaultPropertySource(secret, accessor);
        }
        catch (Throwable throwable) {
            this.secretLeaseContainer.removeLeaseErrorListener(errorListener);
            Exception exception = (Exception)errorRef.get();
            if (exception != null) {
                if (exception instanceof VaultException) {
                    throw (VaultException)((Object)exception);
                }
                throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception);
            }
            throw throwable;
        }
        this.secretLeaseContainer.removeLeaseErrorListener(errorListener);
        Exception exception = (Exception)errorRef.get();
        if (exception != null) {
            if (exception instanceof VaultException) {
                throw (VaultException)((Object)exception);
            }
            throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception);
        }
        return propertySource;
    }

    private PropertySource<?> createVaultPropertySource(RequestedSecret secret, SecretBackendMetadata accessor) {
        return new LeaseAwareVaultPropertySource(accessor.getName(), this.secretLeaseContainer, secret, accessor.getPropertyTransformer());
    }
}

