/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.LeasingVaultPropertySourceLocator;
import org.springframework.cloud.vault.config.SecretBackendFactories;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultConfigTemplate;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocator;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AppIdAuthentication;
import org.springframework.vault.authentication.AppIdAuthenticationOptions;
import org.springframework.vault.authentication.AppIdUserIdMechanism;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.AwsEc2Authentication;
import org.springframework.vault.authentication.AwsEc2AuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ClientCertificateAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.authentication.IpAddressUserId;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.MacAddressUserId;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.authentication.StaticUserId;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.config.ClientHttpRequestFactoryFactory;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultProperties.class, VaultGenericBackendProperties.class})
public class VaultBootstrapConfiguration
implements InitializingBean {
    private final ConfigurableApplicationContext applicationContext;
    private final VaultProperties vaultProperties;
    private final VaultEndpoint vaultEndpoint;
    private RestOperations restOperations;
    private Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors;
    private Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories;

    public VaultBootstrapConfiguration(ConfigurableApplicationContext applicationContext, VaultProperties vaultProperties) {
        this.applicationContext = applicationContext;
        this.vaultProperties = vaultProperties;
        this.vaultEndpoint = this.getVaultEndpoint(vaultProperties);
    }

    private VaultEndpoint getVaultEndpoint(VaultProperties vaultProperties) {
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(vaultProperties.getHost());
        vaultEndpoint.setPort(vaultProperties.getPort());
        vaultEndpoint.setScheme(vaultProperties.getScheme());
        return vaultEndpoint;
    }

    public void afterPropertiesSet() throws Exception {
        this.vaultSecretBackendDescriptors = this.applicationContext.getBeansOfType(VaultSecretBackendDescriptor.class).values();
        this.factories = this.applicationContext.getBeansOfType(SecretBackendMetadataFactory.class).values();
        ClientHttpRequestFactory clientHttpRequestFactory = this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory();
        this.restOperations = VaultClients.createRestTemplate((VaultEndpoint)this.vaultEndpoint, (ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    @Bean
    public PropertySourceLocator vaultPropertySourceLocator(VaultOperations operations, VaultProperties vaultProperties, VaultGenericBackendProperties vaultGenericBackendProperties, ObjectFactory<SecretLeaseContainer> secretLeaseContainerObjectFactory) {
        Collection<SecretBackendMetadata> backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
        VaultConfigTemplate vaultConfigTemplate = new VaultConfigTemplate(operations, vaultProperties);
        if (vaultProperties.getConfig().getLifecycle().isEnabled()) {
            this.applicationContext.registerShutdownHook();
            SecretLeaseContainer secretLeaseContainer = (SecretLeaseContainer)secretLeaseContainerObjectFactory.getObject();
            secretLeaseContainer.start();
            return new LeasingVaultPropertySourceLocator(vaultProperties, vaultGenericBackendProperties, backendAccessors, secretLeaseContainer);
        }
        return new VaultPropertySourceLocator(vaultConfigTemplate, vaultProperties, vaultGenericBackendProperties, backendAccessors);
    }

    @Bean
    @ConditionalOnMissingBean
    public AbstractVaultConfiguration.ClientFactoryWrapper clientHttpRequestFactoryWrapper() {
        ClientOptions clientOptions = new ClientOptions(this.vaultProperties.getConnectionTimeout(), this.vaultProperties.getReadTimeout());
        VaultProperties.Ssl ssl = this.vaultProperties.getSsl();
        SslConfiguration sslConfiguration = ssl != null ? new SslConfiguration(ssl.getKeyStore(), ssl.getKeyStorePassword(), ssl.getTrustStore(), ssl.getTrustStorePassword()) : SslConfiguration.NONE;
        return new AbstractVaultConfiguration.ClientFactoryWrapper(ClientHttpRequestFactoryFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration));
    }

    @Bean
    @ConditionalOnMissingBean
    public VaultTemplate vaultTemplate(SessionManager sessionManager) {
        return new VaultTemplate(this.vaultEndpoint, this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory(), sessionManager);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={TaskSchedulerWrapper.class})
    public TaskSchedulerWrapper vaultTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(2);
        threadPoolTaskScheduler.setDaemon(true);
        threadPoolTaskScheduler.setThreadNamePrefix("Spring-Cloud-Vault-");
        this.applicationContext.registerShutdownHook();
        return new TaskSchedulerWrapper(threadPoolTaskScheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionManager sessionManager(ClientAuthentication clientAuthentication, ObjectFactory<TaskSchedulerWrapper> asyncTaskExecutorFactory) {
        if (this.vaultProperties.getConfig().getLifecycle().isEnabled()) {
            return new LifecycleAwareSessionManager(clientAuthentication, (TaskScheduler)((TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), this.restOperations);
        }
        return new SimpleSessionManager(clientAuthentication);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public SecretLeaseContainer secretLeaseContainer(VaultOperations vaultOperations, TaskSchedulerWrapper taskSchedulerWrapper) {
        return new SecretLeaseContainer(vaultOperations, (TaskScheduler)taskSchedulerWrapper.getTaskScheduler());
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientAuthentication clientAuthentication() {
        switch (this.vaultProperties.getAuthentication()) {
            case TOKEN: {
                Assert.hasText((String)this.vaultProperties.getToken(), (String)"Token (spring.cloud.vault.token) must not be empty");
                return new TokenAuthentication(this.vaultProperties.getToken());
            }
            case APPID: {
                return this.appIdAuthentication(this.vaultProperties);
            }
            case APPROLE: {
                return this.appRoleAuthentication(this.vaultProperties);
            }
            case CERT: {
                return new ClientCertificateAuthentication(this.restOperations);
            }
            case AWS_EC2: {
                return this.awsEc2Authentication(this.vaultProperties);
            }
            case CUBBYHOLE: {
                return this.cubbyholeAuthentication();
            }
        }
        throw new UnsupportedOperationException(String.format("Client authentication %s not supported", new Object[]{this.vaultProperties.getAuthentication()}));
    }

    private ClientAuthentication appIdAuthentication(VaultProperties vaultProperties) {
        VaultProperties.AppIdProperties appId = vaultProperties.getAppId();
        Assert.hasText((String)appId.getUserId(), (String)"UserId (spring.cloud.vault.app-id.user-id) must not be empty");
        AppIdAuthenticationOptions authenticationOptions = AppIdAuthenticationOptions.builder().appId(vaultProperties.getApplicationName()).path(appId.getAppIdPath()).userIdMechanism(this.getClientAuthentication(appId)).build();
        return new AppIdAuthentication(authenticationOptions, this.restOperations);
    }

    private AppIdUserIdMechanism getClientAuthentication(VaultProperties.AppIdProperties appId) {
        try {
            Class userIdClass = ClassUtils.forName((String)appId.getUserId(), null);
            return (AppIdUserIdMechanism)BeanUtils.instantiateClass((Class)userIdClass);
        }
        catch (ClassNotFoundException ex) {
            switch (appId.getUserId().toUpperCase()) {
                case "IP_ADDRESS": {
                    return new IpAddressUserId();
                }
                case "MAC_ADDRESS": {
                    if (StringUtils.hasText((String)appId.getNetworkInterface())) {
                        try {
                            return new MacAddressUserId(Integer.parseInt(appId.getNetworkInterface()));
                        }
                        catch (NumberFormatException e) {
                            return new MacAddressUserId(appId.getNetworkInterface());
                        }
                    }
                    return new MacAddressUserId();
                }
            }
            return new StaticUserId(appId.getUserId());
        }
    }

    private ClientAuthentication appRoleAuthentication(VaultProperties vaultProperties) {
        VaultProperties.AppRoleProperties appRole = vaultProperties.getAppRole();
        Assert.hasText((String)appRole.getRoleId(), (String)"RoleId (spring.cloud.vault.app-role.role-id) must not be empty");
        AppRoleAuthenticationOptions.AppRoleAuthenticationOptionsBuilder builder = AppRoleAuthenticationOptions.builder().path(appRole.getAppRolePath()).roleId(appRole.getRoleId());
        if (StringUtils.hasText((String)appRole.getSecretId())) {
            builder = builder.secretId(appRole.getSecretId());
        }
        return new AppRoleAuthentication(builder.build(), this.restOperations);
    }

    private ClientAuthentication awsEc2Authentication(VaultProperties vaultProperties) {
        VaultProperties.AwsEc2Properties awsEc2 = vaultProperties.getAwsEc2();
        AwsEc2AuthenticationOptions authenticationOptions = AwsEc2AuthenticationOptions.builder().role(awsEc2.getRole()).path(awsEc2.getAwsEc2Path()).identityDocumentUri(URI.create(awsEc2.getIdentityDocument())).build();
        return new AwsEc2Authentication(authenticationOptions, this.restOperations, this.restOperations);
    }

    private ClientAuthentication cubbyholeAuthentication() {
        Assert.hasText((String)this.vaultProperties.getToken(), (String)"Initial Token (spring.cloud.vault.token) for Cubbyhole authentication must not be empty");
        CubbyholeAuthenticationOptions options = CubbyholeAuthenticationOptions.builder().wrapped().initialToken(VaultToken.of((String)this.vaultProperties.getToken())).build();
        return new CubbyholeAuthentication(options, this.restOperations);
    }

    public static class TaskSchedulerWrapper
    implements InitializingBean,
    DisposableBean {
        private final ThreadPoolTaskScheduler taskScheduler;

        public TaskSchedulerWrapper(ThreadPoolTaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
        }

        ThreadPoolTaskScheduler getTaskScheduler() {
            return this.taskScheduler;
        }

        public void destroy() throws Exception {
            this.taskScheduler.destroy();
        }

        public void afterPropertiesSet() throws Exception {
            this.taskScheduler.afterPropertiesSet();
        }
    }
}

