/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Collection;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultConfigOperations;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySource;
import org.springframework.cloud.vault.config.VaultPropertySourceLocatorSupport;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

class VaultPropertySourceLocator
extends VaultPropertySourceLocatorSupport
implements PriorityOrdered {
    private final VaultConfigOperations operations;
    private final VaultProperties properties;

    public VaultPropertySourceLocator(VaultConfigOperations operations, VaultProperties properties, VaultGenericBackendProperties genericBackendProperties, Collection<SecretBackendMetadata> backendAccessors) {
        super("vault", genericBackendProperties, backendAccessors);
        Assert.notNull((Object)operations, (String)"VaultConfigOperations must not be null");
        Assert.notNull((Object)properties, (String)"VaultProperties must not be null");
        this.operations = operations;
        this.properties = properties;
    }

    public int getOrder() {
        return this.properties.getConfig().getOrder();
    }

    @Override
    protected void initialize(CompositePropertySource propertySource) {
        for (PropertySource source : propertySource.getPropertySources()) {
            ((VaultPropertySource)source).init();
        }
    }

    @Override
    protected PropertySource<?> createVaultPropertySource(SecretBackendMetadata accessor) {
        return new VaultPropertySource(this.operations, this.properties.isFailFast(), accessor);
    }
}

