/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.GenericSecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class VaultPropertySourceLocatorSupport
implements PropertySourceLocator {
    private final String propertySourceName;
    private final VaultGenericBackendProperties genericBackendProperties;
    private final Collection<SecretBackendMetadata> backendAccessors;

    public VaultPropertySourceLocatorSupport(String propertySourceName, VaultGenericBackendProperties genericBackendProperties, Collection<SecretBackendMetadata> backendAccessors) {
        Assert.hasText((String)propertySourceName, (String)"PropertySource name must not be empty");
        Assert.notNull(backendAccessors, (String)"BackendAccessors must not be null");
        Assert.notNull((Object)genericBackendProperties, (String)"VaultGenericBackendProperties must not be null");
        this.propertySourceName = propertySourceName;
        this.backendAccessors = backendAccessors;
        this.genericBackendProperties = genericBackendProperties;
    }

    public PropertySource<?> locate(Environment environment) {
        CompositePropertySource propertySource = this.createCompositePropertySource(environment);
        this.initialize(propertySource);
        return propertySource;
    }

    protected void initialize(CompositePropertySource propertySource) {
    }

    protected CompositePropertySource createCompositePropertySource(Environment environment) {
        List<PropertySource<?>> propertySources = this.doCreatePropertySources(environment);
        return this.doCreateCompositePropertySource(this.propertySourceName, propertySources);
    }

    protected List<PropertySource<?>> doCreatePropertySources(Environment environment) {
        ArrayList propertySources = new ArrayList();
        if (this.genericBackendProperties.isEnabled()) {
            propertySources.addAll(this.doCreateGenericPropertySources(environment));
        }
        for (SecretBackendMetadata backendAccessor : this.backendAccessors) {
            PropertySource<?> vaultPropertySource = this.createVaultPropertySource(backendAccessor);
            propertySources.add(vaultPropertySource);
        }
        return propertySources;
    }

    protected List<PropertySource<?>> doCreateGenericPropertySources(Environment environment) {
        ArrayList propertySources = new ArrayList();
        List<String> contexts = GenericSecretBackendMetadata.buildContexts(this.genericBackendProperties, environment);
        for (String propertySourceContext : contexts) {
            if (!StringUtils.hasText((String)propertySourceContext)) continue;
            PropertySource<?> vaultPropertySource = this.createVaultPropertySource(GenericSecretBackendMetadata.create(this.genericBackendProperties.getBackend(), propertySourceContext));
            propertySources.add(vaultPropertySource);
        }
        return propertySources;
    }

    protected CompositePropertySource doCreateCompositePropertySource(String propertySourceName, List<PropertySource<?>> propertySources) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(propertySourceName);
        for (PropertySource<?> propertySource : propertySources) {
            compositePropertySource.addPropertySource(propertySource);
        }
        return compositePropertySource;
    }

    protected abstract PropertySource<?> createVaultPropertySource(SecretBackendMetadata var1);
}

