/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataSupport;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GenericSecretBackendMetadata
extends SecretBackendMetadataSupport
implements SecretBackendMetadata {
    private final String path;

    private GenericSecretBackendMetadata(String path) {
        Assert.hasText((String)path, (String)"Secret backend path must not be empty");
        this.path = path;
    }

    public static SecretBackendMetadata create(String secretBackendPath, String key) {
        Assert.hasText((String)secretBackendPath, (String)"Secret backend path must not be null or empty");
        Assert.hasText((String)key, (String)"Key must not be null or empty");
        return GenericSecretBackendMetadata.create(String.format("%s/%s", secretBackendPath, key));
    }

    public static SecretBackendMetadata create(String path) {
        return new GenericSecretBackendMetadata(path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public static List<String> buildContexts(VaultGenericBackendProperties genericBackendProperties, List<String> profiles) {
        String appName = genericBackendProperties.getApplicationName();
        LinkedHashSet<String> contexts = new LinkedHashSet<String>();
        String defaultContext = genericBackendProperties.getDefaultContext();
        contexts.addAll(GenericSecretBackendMetadata.buildContexts(defaultContext, profiles, genericBackendProperties.getProfileSeparator()));
        for (String applicationName : StringUtils.commaDelimitedListToSet((String)appName)) {
            contexts.addAll(GenericSecretBackendMetadata.buildContexts(applicationName, profiles, genericBackendProperties.getProfileSeparator()));
        }
        ArrayList<String> result = new ArrayList<String>(contexts);
        Collections.reverse(result);
        return result;
    }

    public static List<String> buildContexts(String applicationName, List<String> profiles, String profileSeparator) {
        ArrayList<String> contexts = new ArrayList<String>();
        if (!StringUtils.hasText((String)applicationName)) {
            return contexts;
        }
        if (!contexts.contains(applicationName)) {
            contexts.add(applicationName);
        }
        for (String profile : profiles) {
            String contextName;
            if (!StringUtils.hasText((String)profile) || contexts.contains(contextName = applicationName + profileSeparator + profile.trim())) continue;
            contexts.add(contextName);
        }
        return contexts;
    }
}

