/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.vault.config.KubernetesAuthenticationOptions;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

class KubernetesAuthentication
implements ClientAuthentication {
    private final KubernetesAuthenticationOptions options;
    private final RestOperations restOperations;

    KubernetesAuthentication(KubernetesAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"KubeAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    public VaultToken login() throws VaultException {
        Map<String, String> login = KubernetesAuthentication.getKubernetesLogin(this.options.getRole(), this.options.getJwtSupplier().get());
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("auth/{mount}/login", login, VaultResponse.class, new Object[]{this.options.getPath()});
            Assert.state((response != null && response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            return KubernetesAuthentication.from(response.getAuth());
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot login using kubernetes: %s", VaultResponses.getError((String)e.getResponseBodyAsString())));
        }
    }

    private static LoginToken from(Map<String, Object> auth) {
        String token = (String)auth.get("client_token");
        Boolean renewable = (Boolean)auth.get("renewable");
        Number leaseDuration = (Number)auth.get("lease_duration");
        if (renewable != null && renewable.booleanValue()) {
            return LoginToken.renewable((String)token, (long)leaseDuration.longValue());
        }
        if (leaseDuration != null) {
            return LoginToken.of((String)token, (long)leaseDuration.longValue());
        }
        return LoginToken.of((String)token);
    }

    private static Map<String, String> getKubernetesLogin(String role, String jwt) {
        Assert.hasText((String)role, (String)"Role must not be empty");
        Assert.hasText((String)role, (String)"JWT must not be empty");
        HashMap<String, String> login = new HashMap<String, String>();
        login.put("jwt", jwt);
        login.put("role", role);
        return login;
    }
}

