/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.cloud.vault.config.KubernetesJwtSupplier;
import org.springframework.cloud.vault.config.KubernetesServiceAccountTokenFile;
import org.springframework.util.Assert;

class KubernetesAuthenticationOptions {
    static final String DEFAULT_KUBERNETES_AUTHENTICATION_PATH = "kubernetes";
    private final String path;
    private final String role;
    private final KubernetesJwtSupplier jwtSupplier;

    private KubernetesAuthenticationOptions(String path, String role, KubernetesJwtSupplier jwtSupplier) {
        this.path = path;
        this.role = role;
        this.jwtSupplier = jwtSupplier;
    }

    static KubernetesAuthenticationOptionsBuilder builder() {
        return new KubernetesAuthenticationOptionsBuilder();
    }

    String getPath() {
        return this.path;
    }

    String getRole() {
        return this.role;
    }

    KubernetesJwtSupplier getJwtSupplier() {
        return this.jwtSupplier;
    }

    static class KubernetesAuthenticationOptionsBuilder {
        private String path = "kubernetes";
        private String role;
        private KubernetesJwtSupplier jwtSupplier;

        KubernetesAuthenticationOptionsBuilder() {
        }

        KubernetesAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        KubernetesAuthenticationOptionsBuilder role(String role) {
            Assert.hasText((String)role, (String)"Role must not be empty");
            this.role = role;
            return this;
        }

        KubernetesAuthenticationOptionsBuilder jwtSupplier(KubernetesJwtSupplier jwtSupplier) {
            Assert.notNull((Object)jwtSupplier, (String)"JwtSupplier must not be null");
            this.jwtSupplier = jwtSupplier;
            return this;
        }

        KubernetesAuthenticationOptions build() {
            Assert.notNull((Object)this.role, (String)"Role must not be null");
            return new KubernetesAuthenticationOptions(this.path, this.role, this.jwtSupplier == null ? new KubernetesServiceAccountTokenFile() : this.jwtSupplier);
        }
    }
}

