/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.support.VaultHealth;

public class VaultHealthIndicator
extends AbstractHealthIndicator {
    private final VaultOperations vaultOperations;

    public VaultHealthIndicator(VaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            VaultHealth vaultHealthResponse = this.vaultOperations.opsForSys().health();
            if (!vaultHealthResponse.isInitialized()) {
                builder.down().withDetail("state", (Object)"Vault uninitialized");
            } else if (vaultHealthResponse.isSealed()) {
                builder.down().withDetail("state", (Object)"Vault sealed");
            } else if (vaultHealthResponse.isStandby()) {
                builder.up().withDetail("state", (Object)"Vault in standby");
            } else {
                builder.up();
            }
            if (StringUtils.hasText((String)vaultHealthResponse.getVersion())) {
                builder.withDetail("version", (Object)vaultHealthResponse.getVersion());
            }
        }
        catch (Exception e) {
            builder.down((Throwable)e);
        }
    }
}

