/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.UndeclaredThrowableException;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.support.VaultHealth;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class VaultReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveVaultOperations vaultOperations;

    public VaultReactiveHealthIndicator(ReactiveVaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    private static Mono<? extends VaultHealthImpl> deserializeError(WebClientResponseException e) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return Mono.just((Object)mapper.readValue(e.getResponseBodyAsByteArray(), VaultHealthImpl.class));
        }
        catch (Exception jsonError) {
            UndeclaredThrowableException t = new UndeclaredThrowableException(jsonError);
            t.addSuppressed((Throwable)e);
            return Mono.error((Throwable)t);
        }
    }

    private static Health getHealth(Health.Builder builder, VaultHealthImpl vaultHealthResponse) {
        if (!vaultHealthResponse.isInitialized()) {
            builder.withDetail("state", (Object)"Vault uninitialized");
        } else if (vaultHealthResponse.isSealed()) {
            builder.down().withDetail("state", (Object)"Vault sealed");
        } else if (vaultHealthResponse.isStandby()) {
            builder.up().withDetail("state", (Object)"Vault in standby");
        } else {
            builder.up();
        }
        if (StringUtils.hasText((String)vaultHealthResponse.getVersion())) {
            builder.withDetail("version", (Object)vaultHealthResponse.getVersion());
        }
        return builder.build();
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return ((Mono)this.vaultOperations.doWithSession(it -> it.get().uri("sys/health", new Object[0]).exchange())).flatMap(it -> it.bodyToMono(VaultHealthImpl.class)).onErrorResume(WebClientResponseException.class, VaultReactiveHealthIndicator::deserializeError).map(vaultHealthResponse -> VaultReactiveHealthIndicator.getHealth(builder, vaultHealthResponse));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class VaultHealthImpl
    implements VaultHealth {
        private final boolean initialized;
        private final boolean sealed;
        private final boolean standby;
        private final int serverTimeUtc;
        @Nullable
        private final String version;

        private VaultHealthImpl(@JsonProperty(value="initialized") boolean initialized, @JsonProperty(value="sealed") boolean sealed, @JsonProperty(value="standby") boolean standby, @JsonProperty(value="server_time_utc") int serverTimeUtc, @Nullable @JsonProperty(value="version") String version) {
            this.initialized = initialized;
            this.sealed = sealed;
            this.standby = standby;
            this.serverTimeUtc = serverTimeUtc;
            this.version = version;
        }

        private VaultHealthImpl() {
            this.initialized = false;
            this.sealed = false;
            this.standby = false;
            this.serverTimeUtc = 0;
            this.version = null;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isSealed() {
            return this.sealed;
        }

        public boolean isStandby() {
            return this.standby;
        }

        public int getServerTimeUtc() {
            return this.serverTimeUtc;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultHealthImpl)) {
                return false;
            }
            VaultHealthImpl other = (VaultHealthImpl)o;
            if (this.isInitialized() != other.isInitialized()) {
                return false;
            }
            if (this.isSealed() != other.isSealed()) {
                return false;
            }
            if (this.isStandby() != other.isStandby()) {
                return false;
            }
            if (this.getServerTimeUtc() != other.getServerTimeUtc()) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInitialized() ? 79 : 97);
            result = result * 59 + (this.isSealed() ? 79 : 97);
            result = result * 59 + (this.isStandby() ? 79 : 97);
            result = result * 59 + this.getServerTimeUtc();
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "VaultReactiveHealthIndicator.VaultHealthImpl(initialized=" + this.isInitialized() + ", sealed=" + this.isSealed() + ", standby=" + this.isStandby() + ", serverTimeUtc=" + this.getServerTimeUtc() + ", version=" + this.getVersion() + ")";
        }
    }
}

