/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.support.SslConfiguration;

final class VaultConfigurationUtil {
    private VaultConfigurationUtil() {
    }

    static SslConfiguration createSslConfiguration(VaultProperties.Ssl ssl) {
        if (ssl == null) {
            return SslConfiguration.unconfigured();
        }
        SslConfiguration.KeyStoreConfiguration keyStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
        SslConfiguration.KeyStoreConfiguration trustStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
        if (ssl.getKeyStore() != null) {
            keyStore = StringUtils.hasText((String)ssl.getKeyStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore(), (char[])ssl.getKeyStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore());
        }
        if (ssl.getTrustStore() != null) {
            trustStore = StringUtils.hasText((String)ssl.getTrustStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore(), (char[])ssl.getTrustStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore());
        }
        return new SslConfiguration(keyStore, trustStore);
    }

    static VaultEndpoint createVaultEndpoint(VaultProperties vaultProperties) {
        if (StringUtils.hasText((String)vaultProperties.getUri())) {
            return VaultEndpoint.from((URI)URI.create(vaultProperties.getUri()));
        }
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(vaultProperties.getHost());
        vaultEndpoint.setPort(vaultProperties.getPort());
        vaultEndpoint.setScheme(vaultProperties.getScheme());
        return vaultEndpoint;
    }
}

