/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.function.Function;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.cloud.zookeeper.CuratorFrameworkCustomizer;

public class ZookeeperBootstrapper
implements Bootstrapper {
    private Function<BootstrapContext, RetryPolicy> retryPolicy;
    private Function<BootstrapContext, EnsembleProvider> ensembleProvider;
    private Function<BootstrapContext, TracerDriver> tracerDriver;
    private Function<BootstrapContext, CuratorFrameworkCustomizer> curatorFrameworkCustomizer;

    static Bootstrapper fromBootstrapContext(Function<BootstrapContext, CuratorFramework> factory) {
        return registry -> registry.register(CuratorFramework.class, factory::apply);
    }

    static ZookeeperBootstrapper create() {
        return new ZookeeperBootstrapper();
    }

    public ZookeeperBootstrapper retryPolicy(Function<BootstrapContext, RetryPolicy> retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ZookeeperBootstrapper ensembleProvider(Function<BootstrapContext, EnsembleProvider> ensembleProvider) {
        this.ensembleProvider = ensembleProvider;
        return this;
    }

    public ZookeeperBootstrapper tracerDriver(Function<BootstrapContext, TracerDriver> tracerDriver) {
        this.tracerDriver = tracerDriver;
        return this;
    }

    public ZookeeperBootstrapper curatorFrameworkCustomizer(Function<BootstrapContext, CuratorFrameworkCustomizer> curatorFrameworkCustomizer) {
        this.curatorFrameworkCustomizer = curatorFrameworkCustomizer;
        return this;
    }

    public void intitialize(BootstrapRegistry registry) {
        this.register(registry, RetryPolicy.class, this.retryPolicy);
        this.register(registry, EnsembleProvider.class, this.ensembleProvider);
        this.register(registry, TracerDriver.class, this.tracerDriver);
        this.register(registry, CuratorFrameworkCustomizer.class, this.curatorFrameworkCustomizer);
    }

    private <T> void register(BootstrapRegistry registry, Class<T> type, Function<BootstrapContext, T> factory) {
        if (this.retryPolicy != null) {
            registry.register(type, factory::apply);
        }
    }
}

