/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.zookeeper.CuratorFrameworkCustomizer;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;

public abstract class CuratorFactory {
    private static final Log log = LogFactory.getLog(ZookeeperAutoConfiguration.class);

    public static CuratorFramework curatorFramework(ZookeeperProperties properties, RetryPolicy retryPolicy, Supplier<Stream<CuratorFrameworkCustomizer>> optionalCuratorFrameworkCustomizerProvider, Supplier<EnsembleProvider> optionalEnsembleProvider, Supplier<TracerDriver> optionalTracerDriverProvider) throws Exception {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        EnsembleProvider ensembleProvider = optionalEnsembleProvider.get();
        if (ensembleProvider != null) {
            builder.ensembleProvider(ensembleProvider);
        } else {
            builder.connectString(properties.getConnectString());
        }
        builder.sessionTimeoutMs((int)properties.getSessionTimeout().toMillis()).connectionTimeoutMs((int)properties.getConnectionTimeout().toMillis()).retryPolicy(retryPolicy);
        Stream<CuratorFrameworkCustomizer> customizers = optionalCuratorFrameworkCustomizerProvider.get();
        if (customizers != null) {
            customizers.forEach(curatorFrameworkCustomizer -> curatorFrameworkCustomizer.customize(builder));
        }
        CuratorFramework curator = builder.build();
        TracerDriver tracerDriver = optionalTracerDriverProvider.get();
        if (tracerDriver != null && curator.getZookeeperClient() != null) {
            curator.getZookeeperClient().setTracerDriver(tracerDriver);
        }
        curator.start();
        if (log.isTraceEnabled()) {
            log.trace((Object)("blocking until connected to zookeeper for " + properties.getBlockUntilConnectedWait() + properties.getBlockUntilConnectedUnit()));
        }
        curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
        if (log.isTraceEnabled()) {
            log.trace((Object)"connected to zookeeper");
        }
        return curator;
    }

    public static RetryPolicy retryPolicy(ZookeeperProperties properties) {
        return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
    }

    public static void registerCurator(BootstrapRegistry registery, UriComponents location, boolean optional) {
        CuratorFactory.registerCurator(registery, location, optional, bootstrapContext -> true);
    }

    public static void registerCurator(BootstrapRegistry registery, UriComponents location, boolean optional, Predicate<BootstrapContext> predicate) {
        registery.registerIfAbsent(ZookeeperProperties.class, context -> {
            if (!predicate.test(context)) {
                return null;
            }
            return CuratorFactory.loadProperties((Binder)context.get(Binder.class), location);
        });
        registery.registerIfAbsent(RetryPolicy.class, context -> {
            if (!predicate.test(context)) {
                return null;
            }
            return CuratorFactory.retryPolicy((ZookeeperProperties)context.get(ZookeeperProperties.class));
        });
        registery.registerIfAbsent(CuratorFramework.class, context -> {
            if (!predicate.test(context)) {
                return null;
            }
            return CuratorFactory.curatorFramework(context, (ZookeeperProperties)context.get(ZookeeperProperties.class), optional);
        });
        registery.addCloseListener(event -> {
            BootstrapContext context = event.getBootstrapContext();
            if (predicate.test(context)) {
                CuratorFramework curatorFramework = (CuratorFramework)context.get(CuratorFramework.class);
                if (!event.getApplicationContext().getBeanFactory().containsBean("configDataCuratorFramework")) {
                    event.getApplicationContext().getBeanFactory().registerSingleton("configDataCuratorFramework", (Object)curatorFramework);
                }
            }
        });
    }

    static ZookeeperProperties loadProperties(Binder binder, UriComponents location) {
        ZookeeperProperties properties = (ZookeeperProperties)binder.bind("spring.cloud.zookeeper", Bindable.of(ZookeeperProperties.class)).orElse((Object)new ZookeeperProperties());
        if (location != null && StringUtils.hasText((String)location.getHost())) {
            if (location.getPort() < 0) {
                throw new IllegalArgumentException("zookeeper port must be greater than or equal to zero: " + location.getPort());
            }
            properties.setConnectString(location.getHost() + ":" + location.getPort());
        }
        return properties;
    }

    private static CuratorFramework curatorFramework(BootstrapContext context, ZookeeperProperties properties, boolean optional) {
        Supplier<Stream<CuratorFrameworkCustomizer>> customizers;
        try {
            CuratorFrameworkCustomizer customizer = (CuratorFrameworkCustomizer)context.get(CuratorFrameworkCustomizer.class);
            customizers = () -> Stream.of(customizer);
        }
        catch (IllegalStateException e) {
            customizers = () -> null;
        }
        try {
            return CuratorFactory.curatorFramework(properties, (RetryPolicy)context.get(RetryPolicy.class), customizers, CuratorFactory.supplier(context, EnsembleProvider.class), CuratorFactory.supplier(context, TracerDriver.class));
        }
        catch (Exception e) {
            if (!optional) {
                log.error((Object)"Unable to connect to zookeeper", (Throwable)e);
                throw new ZookeeperConnectException("Unable to connect to zookeeper", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to connect to zookeeper", (Throwable)e);
            }
            return null;
        }
    }

    private static <T> Supplier<T> supplier(BootstrapContext context, Class<T> type) {
        try {
            Object instance = context.get(type);
            return () -> instance;
        }
        catch (IllegalStateException e) {
            return () -> null;
        }
    }

    private static class ZookeeperConnectException
    extends ConfigDataException {
        protected ZookeeperConnectException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

