/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactoryBean
implements BeanNameAware,
BeanFactoryAware,
BeanClassLoaderAware,
DisposableBean,
InitializingBean,
FactoryBean<Cache>,
PersistenceExceptionTranslator {
    private static final Log log = LogFactory.getLog(CacheFactoryBean.class);
    private Cache cache;
    private Resource cacheXml;
    private Properties properties;
    private DistributedSystem system;
    private ClassLoader beanClassLoader;
    private GemfireBeanFactoryLocator factoryLocator = new GemfireBeanFactoryLocator();
    private BeanFactory beanFactory;
    private String beanName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.factoryLocator.setBeanFactory(this.beanFactory);
        this.factoryLocator.setBeanName(this.beanName);
        this.factoryLocator.afterPropertiesSet();
        Properties cfgProps = this.mergeProperties();
        this.system = DistributedSystem.connect((Properties)cfgProps);
        DistributedMember member = this.system.getDistributedMember();
        log.info((Object)("Connected to Distributed System [" + this.system.getName() + "=" + member.getId() + "@" + member.getHost() + "]"));
        Thread th = Thread.currentThread();
        ClassLoader oldTCCL = th.getContextClassLoader();
        try {
            th.setContextClassLoader(this.beanClassLoader);
            String msg = null;
            try {
                this.cache = CacheFactory.getInstance((DistributedSystem)this.system);
                msg = "Retrieved existing";
            }
            catch (CacheClosedException ex) {
                this.cache = CacheFactory.create((DistributedSystem)this.system);
                msg = "Created";
            }
            log.info((Object)(msg + " GemFire v." + CacheFactory.getVersion() + " Cache [" + this.cache.getName() + "]"));
            if (this.cacheXml != null) {
                this.cache.loadCacheXml(this.cacheXml.getInputStream());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized cache from " + this.cacheXml));
            }
        }
        finally {
            th.setContextClassLoader(oldTCCL);
        }
    }

    private Properties mergeProperties() {
        Properties cfgProps = this.properties != null ? (Properties)this.properties.clone() : new Properties();
        return cfgProps;
    }

    public void destroy() throws Exception {
        if (this.cache != null && !this.cache.isClosed()) {
            this.cache.close();
        }
        this.cache = null;
        if (this.system != null && this.system.isConnected()) {
            DistributedSystem.releaseThreadsSockets();
            this.system.disconnect();
        }
        this.system = null;
        this.factoryLocator.destroy();
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException wrapped;
        if (ex instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex);
        }
        if (ex instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(ex)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        return null;
    }

    public Cache getObject() throws Exception {
        return this.cache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }
}

