/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.SelectResults;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.dao.DataAccessException;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemfireTemplate
extends GemfireAccessor {
    private boolean exposeNativeRegion = false;
    private Region<?, ?> regionProxy;

    public GemfireTemplate() {
    }

    public <K, V> GemfireTemplate(Region<K, V> region) {
        this.setRegion(region);
        this.afterPropertiesSet();
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.regionProxy = this.createRegionProxy(this.getRegion());
    }

    public void setExposeNativeRegion(boolean exposeNativeRegion) {
        this.exposeNativeRegion = exposeNativeRegion;
    }

    public boolean isExposeNativeRegion() {
        return this.exposeNativeRegion;
    }

    public <K, V> V get(final K key) {
        return (V)this.execute(new GemfireCallback<V>(){

            @Override
            public V doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                return region.get(key);
            }
        });
    }

    public <K, V> V put(final K key, final V value) {
        return (V)this.execute(new GemfireCallback<V>(){

            @Override
            public V doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                return region.put(key, value);
            }
        });
    }

    public <K, V> V remove(final K key) {
        return (V)this.execute(new GemfireCallback<V>(){

            @Override
            public V doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                return region.remove(key);
            }
        });
    }

    public <E> SelectResults<E> query(final String query) {
        return (SelectResults)this.execute(new GemfireCallback<SelectResults<E>>(){

            @Override
            public SelectResults<E> doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                return region.query(query);
            }
        });
    }

    public <T> T execute(GemfireCallback<T> action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeRegion());
    }

    public <T> T execute(GemfireCallback<T> action, boolean exposeNativeRegion) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            Region<?, ?> regionToExpose = exposeNativeRegion ? this.getRegion() : this.regionProxy;
            T result = action.doInGemfire(regionToExpose);
            return result;
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (GemFireException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    protected <K, V> Region<K, V> createRegionProxy(Region<K, V> region) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(region.getClass(), (ClassLoader)this.getClass().getClassLoader());
        return (Region)Proxy.newProxyInstance(region.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(region));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Region<?, ?> target;

        public CloseSuppressingInvocationHandler(Region<?, ?> target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke(this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

