/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements DisposableBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean destroy = false;
    private boolean close = true;
    private Resource snapshot;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private RegionAttributes<K, V> attributes;
    private Scope scope;
    private DataPolicy dataPolicy;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.postProcess(this.region);
    }

    @Override
    protected Region<K, V> lookupFallback(Cache cache, String regionName) throws Exception {
        AttributesFactory attrFactory;
        if (this.attributes != null) {
            AttributesFactory.validateAttributes(this.attributes);
        }
        AttributesFactory attributesFactory = attrFactory = this.attributes != null ? new AttributesFactory(this.attributes) : new AttributesFactory();
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> listener : this.cacheListeners) {
                attrFactory.addCacheListener(listener);
            }
        }
        if (this.cacheLoader != null) {
            attrFactory.setCacheLoader(this.cacheLoader);
        }
        if (this.cacheWriter != null) {
            attrFactory.setCacheWriter(this.cacheWriter);
        }
        if (this.dataPolicy != null) {
            attrFactory.setDataPolicy(this.dataPolicy);
        }
        if (this.scope != null) {
            attrFactory.setScope(this.scope);
        }
        this.postProcess(attrFactory);
        Region reg = cache.createRegion(regionName, attrFactory.create());
        this.log.info((Object)("Created new cache region [" + regionName + "]"));
        if (this.snapshot != null) {
            reg.loadSnapshot(this.snapshot.getInputStream());
        }
        return reg;
    }

    protected void postProcess(AttributesFactory<K, V> attrFactory) {
    }

    protected void postProcess(Region<K, V> region) {
    }

    public void destroy() throws Exception {
        if (this.region != null) {
            if (this.close) {
                if (!this.region.getCache().isClosed()) {
                    try {
                        this.region.close();
                    }
                    catch (CacheClosedException cacheClosedException) {}
                }
            } else if (this.destroy) {
                this.region.destroyRegion();
            }
        }
        this.region = null;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        if (destroy) {
            this.close = false;
        }
    }

    public void setClose(boolean close) {
        this.close = close;
        if (close) {
            this.destroy = false;
        }
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }
}

