/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V>
implements BeanFactoryAware {
    private Interest<K>[] interests;
    private String poolName;
    private BeanFactory beanFactory;

    @Override
    protected void postProcess(Region<K, V> region) {
        if (!ObjectUtils.isEmpty((Object[])this.interests)) {
            for (Interest<K> interest : this.interests) {
                if (interest instanceof RegexInterest) {
                    region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable());
                    continue;
                }
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable());
            }
        }
    }

    @Override
    protected void postProcess(AttributesFactory<K, V> attrFactory) {
        if (this.beanFactory.isTypeMatch(this.poolName, Pool.class)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found bean definition for pool '" + this.poolName + "'. Eagerly initializing it..."));
            }
            this.beanFactory.getBean(this.poolName, Pool.class);
        }
        attrFactory.setPoolName(this.poolName);
    }

    @Override
    public void destroy() throws Exception {
        Region region = this.getObject();
        try {
            if (region != null && !ObjectUtils.isEmpty((Object[])this.interests)) {
                for (Interest<K> interest : this.interests) {
                    if (interest instanceof RegexInterest) {
                        region.unregisterInterestRegex((String)interest.getKey());
                        continue;
                    }
                    region.unregisterInterest(interest.getKey());
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            this.log.warn((Object)"Cannot unregister cache interests", (Throwable)ex);
        }
        super.destroy();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"pool name is required");
        this.poolName = poolName;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.setPoolName(pool.getName());
    }
}

