/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import java.util.List;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.DiskWriteAttributesFactoryBean;
import org.springframework.data.gemfire.config.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.config.EvictionType;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    private static final String ALIASES_KEY = ParsingUtils.class.getName() + ":aliases";

    ParsingUtils() {
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue(propertyName, (Object)attr);
        }
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyReference(propertyName, attr);
        }
    }

    static void addBeanAliasAsMetadata(Element element, BeanDefinitionBuilder builder) {
        String[] aliases = new String[]{};
        String name = element.getAttributeNS("http://www.springframework.org/schema/beans", "name");
        if (StringUtils.hasLength((String)name)) {
            aliases = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)name));
        }
        BeanMetadataAttribute attr = new BeanMetadataAttribute(ALIASES_KEY, (Object)aliases);
        attr.setSource((Object)element);
        builder.getRawBeanDefinition().addMetadataAttribute(attr);
    }

    static BeanDefinitionHolder replaceBeanAliasAsMetadata(BeanDefinitionHolder holder) {
        BeanDefinition beanDefinition = holder.getBeanDefinition();
        return new BeanDefinitionHolder(beanDefinition, holder.getBeanName(), (String[])beanDefinition.removeAttribute(ALIASES_KEY));
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, "ref");
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String refAttrName) {
        String attr = element.getAttribute(refAttrName);
        boolean hasRef = StringUtils.hasText((String)attr);
        List childElements = DomUtils.getChildElements((Element)element);
        if (hasRef) {
            if (!childElements.isEmpty()) {
                parserContext.getReaderContext().error("either use the '" + refAttrName + "' attribute or a nested bean declaration for '" + element.getLocalName() + "' element, but not both", (Object)element);
            }
            return new RuntimeBeanReference(attr);
        }
        if (childElements.isEmpty()) {
            parserContext.getReaderContext().error("specify either '" + refAttrName + "' attribute or a nested bean declaration for '" + element.getLocalName() + "' element", (Object)element);
        }
        if (childElements.size() == 1) {
            return parserContext.getDelegate().parsePropertySubElement((Element)childElements.get(0), (BeanDefinition)builder.getRawBeanDefinition());
        }
        ManagedList list = new ManagedList();
        for (Element el : childElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(el, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        return list;
    }

    static boolean parseDiskStorage(Element element, BeanDefinitionBuilder beanBuilder) {
        Element diskStoreElement = DomUtils.getChildElementByTagName((Element)element, (String)"disk-store");
        if (diskStoreElement == null) {
            return false;
        }
        BeanDefinitionBuilder diskDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskWriteAttributesFactory.class);
        ParsingUtils.setPropertyValue(diskStoreElement, diskDefBuilder, "synchronous-write", "synchronous");
        ParsingUtils.setPropertyValue(diskStoreElement, diskDefBuilder, "auto-compact", "rollOplogs");
        ParsingUtils.setPropertyValue(diskStoreElement, diskDefBuilder, "max-oplog-size", "maxOplogSize");
        ParsingUtils.setPropertyValue(diskStoreElement, diskDefBuilder, "time-interval", "timeInterval");
        ParsingUtils.setPropertyValue(diskStoreElement, diskDefBuilder, "queue-size", "bytesThreshold");
        List list = DomUtils.getChildElementsByTagName((Element)diskStoreElement, (String)"disk-dir");
        ManagedList locations = new ManagedList(list.size());
        ManagedList sizes = new ManagedList(list.size());
        for (Element diskDirElement : list) {
            locations.add((Object)diskDirElement.getAttribute("location"));
            String attr = diskDirElement.getAttribute("max-size");
            sizes.add((Object)(StringUtils.hasText((String)attr) ? attr : "10240"));
        }
        BeanDefinitionBuilder factoryWrapper = BeanDefinitionBuilder.genericBeanDefinition(DiskWriteAttributesFactoryBean.class);
        factoryWrapper.addPropertyValue("diskAttributesFactory", (Object)diskDefBuilder.getBeanDefinition());
        beanBuilder.addPropertyValue("diskWriteAttributes", (Object)factoryWrapper.getBeanDefinition());
        beanBuilder.addPropertyValue("diskDirs", (Object)locations);
        beanBuilder.addPropertyValue("diskSizes", (Object)sizes);
        return true;
    }

    static boolean parseEviction(ParserContext parserContext, Element element, BeanDefinitionBuilder attrBuilder) {
        Element evictionElement = DomUtils.getChildElementByTagName((Element)element, (String)"eviction");
        if (evictionElement == null) {
            return false;
        }
        BeanDefinitionBuilder evictionDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvictionAttributesFactoryBean.class);
        String attr = evictionElement.getAttribute("type");
        if (StringUtils.hasText((String)attr)) {
            evictionDefBuilder.addPropertyValue("type", (Object)EvictionType.valueOf(attr.toUpperCase()));
        }
        ParsingUtils.setPropertyValue(evictionElement, evictionDefBuilder, "threshold", "threshold");
        ParsingUtils.setPropertyValue(evictionElement, evictionDefBuilder, "action", "action");
        Element objectSizerElement = DomUtils.getChildElementByTagName((Element)evictionElement, (String)"object-sizer");
        if (objectSizerElement != null) {
            Object sizer = ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, objectSizerElement, evictionDefBuilder);
            evictionDefBuilder.addPropertyValue("ObjectSizer", sizer);
        }
        attrBuilder.addPropertyValue("evictionAttributes", (Object)evictionDefBuilder.getBeanDefinition());
        return true;
    }

    static void parseStatistics(Element element, BeanDefinitionBuilder attrBuilder) {
        ParsingUtils.setPropertyValue(element, attrBuilder, "statistics", "statisticsEnabled");
    }
}

