/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Scope;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.config.AliasReplacingBeanDefinitionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicatedRegionParser
extends AliasReplacingBeanDefinitionParser {
    ReplicatedRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return RegionFactoryBean.class;
    }

    @Override
    protected void doParseInternal(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        String attr = element.getAttribute("persistent");
        if (Boolean.parseBoolean(attr)) {
            builder.addPropertyValue("dataPolicy", (Object)DataPolicy.PERSISTENT_REPLICATE);
        } else {
            builder.addPropertyValue("dataPolicy", (Object)DataPolicy.REPLICATE);
        }
        builder.addPropertyValue("scope", (Object)Scope.DISTRIBUTED_ACK);
        ParsingUtils.setPropertyValue(element, builder, "name", "name");
        attr = element.getAttribute("cache-ref");
        builder.addPropertyReference("cache", StringUtils.hasText((String)attr) ? attr : "gemfire-cache");
        BeanDefinitionBuilder attrBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        ParsingUtils.parseStatistics(element, attrBuilder);
        attr = element.getAttribute("publisher");
        if (StringUtils.hasText((String)attr)) {
            attrBuilder.addPropertyValue("publisher", (Object)Boolean.valueOf(attr));
        }
        ParsingUtils.parseEviction(parserContext, element, attrBuilder);
        ParsingUtils.parseDiskStorage(element, attrBuilder);
        builder.addPropertyValue("attributes", (Object)attrBuilder.getBeanDefinition());
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if ("cache-listener".equals(name)) {
                builder.addPropertyValue("cacheListeners", this.parseCacheListener(parserContext, subElement, builder));
                continue;
            }
            if ("cache-loader".equals(name)) {
                builder.addPropertyValue("cacheLoader", this.parseCacheLoader(parserContext, subElement, builder));
                continue;
            }
            if (!"cache-writer".equals(name)) continue;
            builder.addPropertyValue("cacheWriter", this.parseCacheWriter(parserContext, subElement, builder));
        }
    }

    private Object parseCacheListener(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parseCacheLoader(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parseCacheWriter(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }
}

