/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQL;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.springframework.core.io.Resource;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.DefaultSchemaResourceGraphQlSourceBuilder;
import org.springframework.graphql.execution.ExternalSchemaGraphQlSourceBuilder;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

public interface GraphQlSource {
    public GraphQL graphQl();

    public GraphQLSchema schema();

    public static SchemaResourceBuilder schemaResourceBuilder() {
        return new DefaultSchemaResourceGraphQlSourceBuilder();
    }

    public static Builder<?> builder(GraphQLSchema schema) {
        return new ExternalSchemaGraphQlSourceBuilder(schema);
    }

    public static interface SchemaResourceBuilder
    extends Builder<SchemaResourceBuilder> {
        public SchemaResourceBuilder schemaResources(Resource ... var1);

        public SchemaResourceBuilder configureRuntimeWiring(RuntimeWiringConfigurer var1);

        public SchemaResourceBuilder defaultTypeResolver(TypeResolver var1);

        public SchemaResourceBuilder schemaFactory(BiFunction<TypeDefinitionRegistry, RuntimeWiring, GraphQLSchema> var1);
    }

    public static interface Builder<B extends Builder<B>> {
        public B exceptionResolvers(List<DataFetcherExceptionResolver> var1);

        public B typeVisitors(List<GraphQLTypeVisitor> var1);

        public B instrumentation(List<Instrumentation> var1);

        public B configureGraphQl(Consumer<GraphQL.Builder> var1);

        public GraphQlSource build();
    }
}

