/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.RuntimeWiring;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class SchemaMappingInspector {
    private static final Log logger = LogFactory.getLog(SchemaMappingInspector.class);
    private final GraphQLSchema schema;
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final InterfaceUnionLookup interfaceUnionLookup;
    private final Set<String> inspectedTypes = new HashSet<String>();
    private final ReportBuilder reportBuilder = new ReportBuilder();
    @Nullable
    private SchemaReport report;

    private SchemaMappingInspector(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers, InterfaceUnionLookup interfaceUnionLookup) {
        Assert.notNull((Object)schema, (String)"GraphQLSchema is required");
        Assert.notNull(dataFetchers, (String)"DataFetcher map is required");
        Assert.notNull((Object)interfaceUnionLookup, (String)"InterfaceUnionLookup is required");
        this.schema = schema;
        this.dataFetchers = dataFetchers;
        this.interfaceUnionLookup = interfaceUnionLookup;
    }

    public SchemaReport getOrCreateReport() {
        if (this.report == null) {
            this.checkSchemaFields();
            this.checkDataFetcherRegistrations();
            this.report = this.reportBuilder.build();
        }
        return this.report;
    }

    private void checkSchemaFields() {
        this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getQueryType(), null);
        if (this.schema.isSupportingMutations()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getMutationType(), null);
        }
        if (this.schema.isSupportingSubscriptions()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getSubscriptionType(), null);
        }
    }

    private void checkFieldsContainer(GraphQLFieldsContainer fieldContainer, @Nullable ResolvableType resolvableType) {
        if (!this.inspectedTypes.add(fieldContainer.getName())) {
            return;
        }
        String typeName = fieldContainer.getName();
        Map dataFetcherMap = this.dataFetchers.getOrDefault(typeName, Collections.emptyMap());
        for (GraphQLFieldDefinition field : fieldContainer.getFieldDefinitions()) {
            PropertyDescriptor descriptor;
            String fieldName = field.getName();
            DataFetcher dataFetcher = (DataFetcher)dataFetcherMap.get(fieldName);
            if (dataFetcher != null) {
                if (dataFetcher instanceof SelfDescribingDataFetcher) {
                    SelfDescribingDataFetcher selfDescribing = (SelfDescribingDataFetcher)dataFetcher;
                    this.checkFieldArguments(field, selfDescribing);
                    this.checkField(fieldContainer, field, selfDescribing.getReturnType());
                    continue;
                }
                this.checkField(fieldContainer, field, ResolvableType.NONE);
                continue;
            }
            if (resolvableType != null && (descriptor = this.getProperty(resolvableType, fieldName)) != null) {
                this.checkField(fieldContainer, field, ResolvableType.forMethodReturnType((Method)descriptor.getReadMethod()));
                continue;
            }
            this.reportBuilder.unmappedField(FieldCoordinates.coordinates((String)typeName, (String)fieldName));
        }
    }

    private void checkFieldArguments(GraphQLFieldDefinition field, SelfDescribingDataFetcher<?> dataFetcher) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String name : dataFetcher.getArguments().keySet()) {
            if (field.getArgument(name) != null) continue;
            arguments.add(name);
        }
        if (!arguments.isEmpty()) {
            this.reportBuilder.unmappedArgument(dataFetcher, arguments);
        }
    }

    private void checkField(GraphQLFieldsContainer parent, GraphQLFieldDefinition field, ResolvableType resolvableType) {
        TypePair typePair = TypePair.resolveTypePair((GraphQLType)parent, field, resolvableType, this.schema);
        LinkedMultiValueMap typePairs = new LinkedMultiValueMap();
        GraphQLType graphQLType = typePair.outputType();
        if (graphQLType instanceof GraphQLUnionType) {
            GraphQLUnionType unionType = (GraphQLUnionType)graphQLType;
            typePairs.putAll(this.interfaceUnionLookup.resolveUnion(unionType));
        } else {
            graphQLType = typePair.outputType();
            if (graphQLType instanceof GraphQLInterfaceType) {
                GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)graphQLType;
                typePairs.putAll(this.interfaceUnionLookup.resolveInterface(interfaceType));
            }
        }
        if (typePairs.isEmpty()) {
            typePairs.add((Object)typePair.outputType(), (Object)typePair.resolvableType());
        }
        for (Map.Entry entry : typePairs.entrySet()) {
            GraphQLType graphQlType = (GraphQLType)entry.getKey();
            for (ResolvableType currentResolvableType : (List)entry.getValue()) {
                if (!(graphQlType instanceof GraphQLFieldsContainer)) {
                    if (!SchemaMappingInspector.isNotScalarOrEnumType(graphQlType)) continue;
                    this.reportBuilder.skippedType(graphQlType, parent, field, "Unsupported schema type", false);
                    continue;
                }
                GraphQLFieldsContainer fieldContainer = (GraphQLFieldsContainer)graphQlType;
                if (currentResolvableType.resolve(Object.class) == Object.class) {
                    boolean isDerived = !graphQlType.equals(typePair.outputType());
                    this.reportBuilder.skippedType(graphQlType, parent, field, "No class information", isDerived);
                    continue;
                }
                this.checkFieldsContainer(fieldContainer, currentResolvableType);
            }
        }
    }

    @Nullable
    private PropertyDescriptor getProperty(ResolvableType resolvableType, String fieldName) {
        try {
            Class clazz = resolvableType.resolve();
            return clazz != null ? BeanUtils.getPropertyDescriptor((Class)clazz, (String)fieldName) : null;
        }
        catch (BeansException ex) {
            throw new IllegalStateException("Failed to get property on " + resolvableType + " for field '" + fieldName + "'", ex);
        }
    }

    private static boolean isNotScalarOrEnumType(GraphQLType type) {
        return !(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType);
    }

    private void checkDataFetcherRegistrations() {
        this.dataFetchers.forEach((typeName, registrations) -> registrations.forEach((fieldName, dataFetcher) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldName);
            if (this.schema.getFieldDefinition(coordinates) == null) {
                this.reportBuilder.unmappedRegistration(coordinates, (DataFetcher<?>)dataFetcher);
            }
        }));
    }

    public static SchemaReport inspect(GraphQLSchema schema, RuntimeWiring runtimeWiring) {
        return SchemaMappingInspector.inspect(schema, runtimeWiring.getDataFetchers());
    }

    public static SchemaReport inspect(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> fetchers) {
        return SchemaMappingInspector.initializer().inspect(schema, fetchers);
    }

    public static Initializer initializer() {
        return new DefaultInitializer();
    }

    private final class ReportBuilder {
        private final List<FieldCoordinates> unmappedFields = new ArrayList<FieldCoordinates>();
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations = new LinkedHashMap();
        private final MultiValueMap<DataFetcher<?>, String> unmappedArguments = new LinkedMultiValueMap();
        private final List<DefaultSkippedType> skippedTypes = new ArrayList<DefaultSkippedType>();
        private final List<DefaultSkippedType> candidateSkippedTypes = new ArrayList<DefaultSkippedType>();

        private ReportBuilder() {
        }

        void unmappedField(FieldCoordinates coordinates) {
            this.unmappedFields.add(coordinates);
        }

        void unmappedRegistration(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            this.unmappedRegistrations.put(coordinates, dataFetcher);
        }

        void unmappedArgument(DataFetcher<?> dataFetcher, List<String> arguments) {
            this.unmappedArguments.put(dataFetcher, arguments);
        }

        void skippedType(GraphQLType type, GraphQLFieldsContainer parent, GraphQLFieldDefinition field, String reason, boolean isDerivedType) {
            DefaultSkippedType skippedType = DefaultSkippedType.create(type, parent, field, reason);
            if (!isDerivedType) {
                this.skippedType(skippedType);
                return;
            }
            this.candidateSkippedTypes.add(skippedType);
        }

        private void skippedType(DefaultSkippedType skippedType) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping '" + skippedType + "': " + skippedType.reason()));
            }
            this.skippedTypes.add(skippedType);
        }

        SchemaReport build() {
            this.candidateSkippedTypes.forEach(skippedType -> {
                GraphQLFieldsContainer fieldsContainer;
                GraphQLType patt28758$temp = skippedType.type();
                if (patt28758$temp instanceof GraphQLFieldsContainer && SchemaMappingInspector.this.inspectedTypes.contains((fieldsContainer = (GraphQLFieldsContainer)patt28758$temp).getName())) {
                    return;
                }
                this.skippedType((DefaultSkippedType)skippedType);
            });
            return new DefaultSchemaReport(this.unmappedFields, this.unmappedRegistrations, this.unmappedArguments, this.skippedTypes);
        }
    }

    private static final class InterfaceUnionLookup {
        private static final LinkedMultiValueMap<GraphQLType, ResolvableType> EMPTY_MAP = new LinkedMultiValueMap(0);
        private final Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings;

        private InterfaceUnionLookup(Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings) {
            this.mappings = mappings;
        }

        MultiValueMap<GraphQLType, ResolvableType> resolveInterface(GraphQLInterfaceType interfaceType) {
            return (MultiValueMap)this.mappings.getOrDefault(interfaceType.getName(), (MultiValueMap<GraphQLType, ResolvableType>)EMPTY_MAP);
        }

        MultiValueMap<GraphQLType, ResolvableType> resolveUnion(GraphQLUnionType unionType) {
            return (MultiValueMap)this.mappings.getOrDefault(unionType.getName(), (MultiValueMap<GraphQLType, ResolvableType>)EMPTY_MAP);
        }

        public static InterfaceUnionLookup create(GraphQLSchema schema, List<ClassResolver> classResolvers) {
            LinkedHashMap<String, MultiValueMap<GraphQLType, ResolvableType>> mappings = new LinkedHashMap<String, MultiValueMap<GraphQLType, ResolvableType>>();
            for (GraphQLNamedType type : schema.getAllTypesAsList()) {
                if (type instanceof GraphQLUnionType) {
                    GraphQLUnionType union = (GraphQLUnionType)type;
                    for (GraphQLNamedOutputType member : union.getTypes()) {
                        InterfaceUnionLookup.addTypeMapping((GraphQLNamedOutputType)union, (GraphQLObjectType)member, classResolvers, mappings);
                    }
                    continue;
                }
                if (!(type instanceof GraphQLObjectType)) continue;
                GraphQLObjectType objectType = (GraphQLObjectType)type;
                for (GraphQLNamedOutputType interfaceType : objectType.getInterfaces()) {
                    InterfaceUnionLookup.addTypeMapping(interfaceType, objectType, classResolvers, mappings);
                }
            }
            return new InterfaceUnionLookup(mappings);
        }

        private static void addTypeMapping(GraphQLNamedOutputType interfaceOrUnionType, GraphQLObjectType objectType, List<ClassResolver> classResolvers, Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings) {
            ArrayList<ResolvableType> resolvableTypes = new ArrayList<ResolvableType>();
            for (ClassResolver resolver : classResolvers) {
                List<Class<?>> classes = resolver.resolveClass(objectType, interfaceOrUnionType);
                if (classes.isEmpty()) continue;
                for (Class<?> clazz : classes) {
                    ResolvableType resolvableType = ResolvableType.forClass(clazz);
                    resolvableTypes.add(resolvableType);
                }
            }
            if (resolvableTypes.isEmpty()) {
                resolvableTypes.add(ResolvableType.NONE);
            }
            for (ResolvableType resolvableType : resolvableTypes) {
                String name = interfaceOrUnionType.getName();
                mappings.computeIfAbsent(name, n -> new LinkedMultiValueMap()).add((Object)objectType, (Object)resolvableType);
            }
        }
    }

    private record TypePair(GraphQLType outputType, ResolvableType resolvableType) {
        private static final ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

        public static TypePair resolveTypePair(GraphQLType parent, GraphQLFieldDefinition field, DataFetcher<?> fetcher, GraphQLSchema schema) {
            ResolvableType resolvableType;
            if (fetcher instanceof SelfDescribingDataFetcher) {
                SelfDescribingDataFetcher sd = (SelfDescribingDataFetcher)fetcher;
                resolvableType = sd.getReturnType();
            } else {
                resolvableType = ResolvableType.NONE;
            }
            return TypePair.resolveTypePair(parent, field, resolvableType, schema);
        }

        public static TypePair resolveTypePair(GraphQLType parent, GraphQLFieldDefinition field, ResolvableType resolvableType, GraphQLSchema schema) {
            GraphQLType outputType = TypePair.unwrapIfNonNull((GraphQLType)field.getType());
            if (TypePair.isPaginatedType(outputType)) {
                outputType = TypePair.getPaginatedType((GraphQLObjectType)outputType, schema);
                resolvableType = TypePair.nestForConnection(resolvableType);
            } else if (outputType instanceof GraphQLList) {
                GraphQLList listType = (GraphQLList)outputType;
                outputType = TypePair.unwrapIfNonNull(listType.getWrappedType());
                resolvableType = TypePair.nestForList(resolvableType, parent == schema.getSubscriptionType());
            } else {
                resolvableType = TypePair.nestIfWrappedType(resolvableType);
            }
            return new TypePair(outputType, resolvableType);
        }

        private static GraphQLType unwrapIfNonNull(GraphQLType type) {
            GraphQLType graphQLType;
            if (type instanceof GraphQLNonNull) {
                GraphQLNonNull graphQLNonNull = (GraphQLNonNull)type;
                graphQLType = graphQLNonNull.getWrappedType();
            } else {
                graphQLType = type;
            }
            return graphQLType;
        }

        private static boolean isPaginatedType(GraphQLType type) {
            GraphQLObjectType objectType;
            return type instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)type).getName().endsWith("Connection") && objectType.getField("edges") != null && objectType.getField("pageInfo") != null;
        }

        private static GraphQLType getPaginatedType(GraphQLObjectType type, GraphQLSchema schema) {
            String name = type.getName().substring(0, type.getName().length() - 10);
            GraphQLType nodeType = schema.getType(name);
            Assert.state((nodeType != null ? 1 : 0) != 0, (String)("No node type for '" + type.getName() + "'"));
            return nodeType;
        }

        private static ResolvableType nestForConnection(ResolvableType type) {
            if (type == ResolvableType.NONE) {
                return type;
            }
            type = TypePair.nestIfWrappedType(type);
            if (logger.isDebugEnabled() && type.getGenerics().length != 1) {
                logger.debug((Object)("Expected Connection type to have a generic parameter: " + type));
            }
            return type.getNested(2);
        }

        private static ResolvableType nestIfWrappedType(ResolvableType type) {
            Class clazz = type.resolve(Object.class);
            if (Optional.class.isAssignableFrom(clazz)) {
                if (logger.isDebugEnabled() && type.getGeneric(new int[]{0}).resolve() == null) {
                    logger.debug((Object)("Expected Optional type to have a generic parameter: " + type));
                }
                return type.getNested(2);
            }
            ReactiveAdapter adapter = adapterRegistry.getAdapter(clazz);
            if (adapter != null) {
                if (logger.isDebugEnabled() && adapter.isNoValue()) {
                    logger.debug((Object)("Expected reactive/async return type that can produce value(s): " + type));
                }
                return type.getNested(2);
            }
            return type;
        }

        private static ResolvableType nestForList(ResolvableType type, boolean subscription) {
            if (type == ResolvableType.NONE) {
                return type;
            }
            ReactiveAdapter adapter = adapterRegistry.getAdapter(type.resolve(Object.class));
            if (adapter != null) {
                if (logger.isDebugEnabled() && adapter.isNoValue()) {
                    logger.debug((Object)("Expected List compatible type: " + type));
                }
                type = type.getNested(2);
                if (adapter.isMultiValue() && !subscription) {
                    return type;
                }
            }
            if (logger.isDebugEnabled() && !type.isArray() && type.getGenerics().length != 1) {
                logger.debug((Object)("Expected List compatible type: " + type));
            }
            return type.getNested(2);
        }
    }

    public static interface Initializer {
        public Initializer classMapping(String var1, Class<?> ... var2);

        public Initializer classNameFunction(Function<GraphQLObjectType, String> var1);

        public Initializer classResolver(ClassResolver var1);

        public SchemaReport inspect(GraphQLSchema var1, Map<String, Map<String, DataFetcher>> var2);
    }

    private static final class DefaultInitializer
    implements Initializer {
        private Function<GraphQLObjectType, String> classNameFunction = GraphQLObjectType::getName;
        private final List<ClassResolver> classResolvers = new ArrayList<ClassResolver>();
        private final MultiValueMap<String, Class<?>> classMappings = new LinkedMultiValueMap();

        private DefaultInitializer() {
        }

        @Override
        public Initializer classNameFunction(Function<GraphQLObjectType, String> function) {
            this.classNameFunction = function;
            return this;
        }

        @Override
        public Initializer classResolver(ClassResolver resolver) {
            this.classResolvers.add(resolver);
            return this;
        }

        @Override
        public Initializer classMapping(String graphQlTypeName, Class<?> ... classes) {
            for (Class<?> aClass : classes) {
                this.classMappings.add((Object)graphQlTypeName, aClass);
            }
            return this;
        }

        @Override
        public SchemaReport inspect(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> fetchers) {
            ArrayList<ClassResolver> resolvers = new ArrayList<ClassResolver>(this.classResolvers);
            resolvers.add(new MappingClassResolver(this.classMappings));
            resolvers.add(ReflectionClassResolver.create(schema, fetchers, this.classNameFunction));
            InterfaceUnionLookup lookup = InterfaceUnionLookup.create(schema, resolvers);
            SchemaMappingInspector inspector = new SchemaMappingInspector(schema, fetchers, lookup);
            return inspector.getOrCreateReport();
        }
    }

    private record DefaultSkippedType(GraphQLType type, FieldCoordinates fieldCoordinates, String reason) implements SchemaReport.SkippedType
    {
        @Override
        public String toString() {
            String string;
            GraphQLType graphQLType = this.type;
            if (graphQLType instanceof GraphQLNamedType) {
                GraphQLNamedType named = (GraphQLNamedType)graphQLType;
                string = named.getName();
            } else {
                string = this.type.toString();
            }
            return string;
        }

        public static DefaultSkippedType create(GraphQLType type, GraphQLFieldsContainer parent, GraphQLFieldDefinition field, String reason) {
            return new DefaultSkippedType(type, FieldCoordinates.coordinates((GraphQLFieldsContainer)parent, (GraphQLFieldDefinition)field), reason);
        }
    }

    private final class DefaultSchemaReport
    implements SchemaReport {
        private final List<FieldCoordinates> unmappedFields;
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations;
        private final MultiValueMap<DataFetcher<?>, String> unmappedArguments;
        private final List<SchemaReport.SkippedType> skippedTypes;

        DefaultSchemaReport(List<FieldCoordinates> unmappedFields, Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations, MultiValueMap<DataFetcher<?>, String> unmappedArguments, List<DefaultSkippedType> skippedTypes) {
            this.unmappedFields = Collections.unmodifiableList(unmappedFields);
            this.unmappedRegistrations = Collections.unmodifiableMap(unmappedRegistrations);
            this.unmappedArguments = CollectionUtils.unmodifiableMultiValueMap(unmappedArguments);
            this.skippedTypes = Collections.unmodifiableList(skippedTypes);
        }

        @Override
        public List<FieldCoordinates> unmappedFields() {
            return this.unmappedFields;
        }

        @Override
        public Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations() {
            return this.unmappedRegistrations;
        }

        @Override
        public MultiValueMap<DataFetcher<?>, String> unmappedArguments() {
            return this.unmappedArguments;
        }

        @Override
        public List<SchemaReport.SkippedType> skippedTypes() {
            return this.skippedTypes;
        }

        @Override
        public GraphQLSchema schema() {
            return SchemaMappingInspector.this.schema;
        }

        @Override
        @Nullable
        public DataFetcher<?> dataFetcher(FieldCoordinates coordinates) {
            return (DataFetcher)SchemaMappingInspector.this.dataFetchers.getOrDefault(coordinates.getTypeName(), Collections.emptyMap()).get(coordinates.getFieldName());
        }

        public String toString() {
            return "GraphQL schema inspection:\n\tUnmapped fields: " + this.formatUnmappedFields() + "\n\tUnmapped registrations: " + this.unmappedRegistrations + "\n\tUnmapped arguments: " + this.unmappedArguments + "\n\tSkipped types: " + this.skippedTypes;
        }

        private String formatUnmappedFields() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            this.unmappedFields.forEach(arg_0 -> DefaultSchemaReport.lambda$formatUnmappedFields$1((MultiValueMap)map, arg_0));
            return map.toString();
        }

        private static /* synthetic */ void lambda$formatUnmappedFields$1(MultiValueMap map, FieldCoordinates coordinates) {
            List fields = (List)map.computeIfAbsent((Object)coordinates.getTypeName(), s -> new ArrayList());
            fields.add(coordinates.getFieldName());
        }
    }

    private static final class ReflectionClassResolver
    implements ClassResolver {
        private static final Predicate<String> PACKAGE_PREDICATE = name -> !name.startsWith("java.");
        private final Function<GraphQLObjectType, String> classNameFunction;
        private final MultiValueMap<String, String> classPrefixes;

        private ReflectionClassResolver(Function<GraphQLObjectType, String> nameFunction, MultiValueMap<String, String> prefixes) {
            this.classNameFunction = nameFunction;
            this.classPrefixes = prefixes;
        }

        @Override
        public List<Class<?>> resolveClass(GraphQLObjectType objectType, GraphQLNamedOutputType interfaceOrUnion) {
            String className = this.classNameFunction.apply(objectType);
            for (String prefix : (List)this.classPrefixes.getOrDefault((Object)interfaceOrUnion.getName(), Collections.emptyList())) {
                try {
                    Class<?> clazz = Class.forName(prefix + className);
                    return Collections.singletonList(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return Collections.emptyList();
        }

        public static ReflectionClassResolver create(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers, Function<GraphQLObjectType, String> classNameFunction) {
            LinkedMultiValueMap classPrefixes = new LinkedMultiValueMap();
            for (Map.Entry<String, Map<String, DataFetcher>> typeEntry : dataFetchers.entrySet()) {
                String typeName = typeEntry.getKey();
                GraphQLType parentType = schema.getType(typeName);
                if (parentType == null) continue;
                for (Map.Entry<String, DataFetcher> fieldEntry : typeEntry.getValue().entrySet()) {
                    SelfDescribingDataFetcher selfDescribing;
                    Object object;
                    DataFetcher dataFetcher;
                    TypePair pair;
                    GraphQLType outputType;
                    FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldEntry.getKey());
                    GraphQLFieldDefinition field = schema.getFieldDefinition(coordinates);
                    if (field == null || !((outputType = (pair = TypePair.resolveTypePair(parentType, field, dataFetcher = fieldEntry.getValue(), schema)).outputType()) instanceof GraphQLUnionType) && !(outputType instanceof GraphQLInterfaceType)) continue;
                    String outputTypeName = ((GraphQLNamedOutputType)outputType).getName();
                    Class clazz = pair.resolvableType().resolve(Object.class);
                    if (PACKAGE_PREDICATE.test(clazz.getPackageName())) {
                        ReflectionClassResolver.addClassPrefix(outputTypeName, clazz, (MultiValueMap<String, String>)classPrefixes);
                    }
                    if (!(dataFetcher instanceof SelfDescribingDataFetcher) || !((object = (selfDescribing = (SelfDescribingDataFetcher)dataFetcher).getReturnType().getSource()) instanceof MethodParameter)) continue;
                    MethodParameter param = (MethodParameter)object;
                    ReflectionClassResolver.addClassPrefix(outputTypeName, param.getDeclaringClass(), (MultiValueMap<String, String>)classPrefixes);
                }
            }
            return new ReflectionClassResolver(classNameFunction, (MultiValueMap<String, String>)classPrefixes);
        }

        private static void addClassPrefix(String unionOrInterfaceType, Class<?> aClass, MultiValueMap<String, String> classPrefixes) {
            int index = aClass.getName().indexOf(aClass.getSimpleName());
            classPrefixes.add((Object)unionOrInterfaceType, (Object)aClass.getName().substring(0, index));
        }
    }

    private static final class MappingClassResolver
    implements ClassResolver {
        private final MultiValueMap<String, Class<?>> mappings = new LinkedMultiValueMap();

        MappingClassResolver(MultiValueMap<String, Class<?>> mappings) {
            this.mappings.putAll(mappings);
        }

        @Override
        public List<Class<?>> resolveClass(GraphQLObjectType objectType, GraphQLNamedOutputType interfaceOrUnionType) {
            return (List)this.mappings.getOrDefault((Object)objectType.getName(), Collections.emptyList());
        }
    }

    public static interface ClassResolver {
        public List<Class<?>> resolveClass(GraphQLObjectType var1, GraphQLNamedOutputType var2);
    }
}

