/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.graphql.observation.DataFetcherObservationContext;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;

public class DefaultDataFetcherObservationConvention
implements DataFetcherObservationConvention {
    private static final String DEFAULT_NAME = "graphql.datafetcher";
    private static final KeyValue OUTCOME_SUCCESS = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherLowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue OUTCOME_ERROR = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherLowCardinalityKeyNames.OUTCOME, (String)"ERROR");
    private static final KeyValue ERROR_TYPE_NONE = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherLowCardinalityKeyNames.ERROR_TYPE, (String)"NONE");
    private final String name;

    public DefaultDataFetcherObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultDataFetcherObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(DataFetcherObservationContext context) {
        return "graphql field " + context.getEnvironment().getField().getName();
    }

    public KeyValues getLowCardinalityKeyValues(DataFetcherObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.outcome(context), this.fieldName(context), this.errorType(context)});
    }

    protected KeyValue outcome(DataFetcherObservationContext context) {
        if (context.getError() != null) {
            return OUTCOME_ERROR;
        }
        return OUTCOME_SUCCESS;
    }

    protected KeyValue fieldName(DataFetcherObservationContext context) {
        return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherLowCardinalityKeyNames.FIELD_NAME, (String)context.getEnvironment().getField().getName());
    }

    protected KeyValue errorType(DataFetcherObservationContext context) {
        if (context.getError() != null) {
            return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherLowCardinalityKeyNames.ERROR_TYPE, (String)context.getError().getClass().getSimpleName());
        }
        return ERROR_TYPE_NONE;
    }

    public KeyValues getHighCardinalityKeyValues(DataFetcherObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.fieldPath(context)});
    }

    protected KeyValue fieldPath(DataFetcherObservationContext context) {
        return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataFetcherHighCardinalityKeyNames.FIELD_PATH, (String)context.getEnvironment().getExecutionStepInfo().getPath().toString());
    }
}

