/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.aop.support.AopUtils;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EmbeddedWrappers {
    private final boolean preferCollections;

    public EmbeddedWrappers(boolean preferCollections) {
        this.preferCollections = preferCollections;
    }

    @Nullable
    public EmbeddedWrapper wrap(@Nullable Object source) {
        return this.wrap(source, AbstractEmbeddedWrapper.NO_REL);
    }

    public EmbeddedWrapper emptyCollectionOf(Class<?> type) {
        return new EmptyCollectionEmbeddedWrapper(type);
    }

    @Nullable
    public EmbeddedWrapper wrap(@Nullable Object source, LinkRelation rel) {
        if (source == null) {
            return null;
        }
        if (source instanceof EmbeddedWrapper) {
            return (EmbeddedWrapper)source;
        }
        if (source instanceof Collection) {
            return new EmbeddedCollection((Collection)source, rel);
        }
        if (this.preferCollections) {
            return new EmbeddedCollection(Collections.singleton(source), rel);
        }
        return new EmbeddedElement(source, rel);
    }

    private static class EmptyCollectionEmbeddedWrapper
    implements EmbeddedWrapper {
        private final Class<?> type;

        public EmptyCollectionEmbeddedWrapper(Class<?> type) {
            Assert.notNull(type, (String)"Element type must not be null!");
            this.type = type;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.empty();
        }

        @Override
        public Object getValue() {
            return Collections.emptySet();
        }

        @Override
        @NonNull
        public Class<?> getRelTargetType() {
            return this.type;
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return false;
        }
    }

    private static class EmbeddedCollection
    extends AbstractEmbeddedWrapper {
        private final Collection<Object> value;

        public EmbeddedCollection(Collection<Object> value, LinkRelation rel) {
            super(rel);
            Assert.notNull(value, (String)"Collection must not be null!");
            if (AbstractEmbeddedWrapper.NO_REL.equals(rel) && value.isEmpty()) {
                throw new IllegalArgumentException("Cannot wrap an empty collection with no rel given!");
            }
            this.value = value;
        }

        @Override
        public Collection<Object> getValue() {
            return this.value;
        }

        @Override
        @Nullable
        protected Object peek() {
            return this.value.isEmpty() ? null : this.value.iterator().next();
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }
    }

    private static class EmbeddedElement
    extends AbstractEmbeddedWrapper {
        private final Object value;

        public EmbeddedElement(Object value, LinkRelation relation) {
            super(relation);
            Assert.notNull((Object)value, (String)"Value must not be null!");
            this.value = value;
        }

        @Override
        @NonNull
        public Object getValue() {
            return this.value;
        }

        @Override
        @NonNull
        protected Object peek() {
            return this.getValue();
        }

        @Override
        public boolean isCollectionValue() {
            return false;
        }
    }

    private static abstract class AbstractEmbeddedWrapper
    implements EmbeddedWrapper {
        private static final LinkRelation NO_REL = LinkRelation.of("___norel___");
        private final LinkRelation rel;

        public AbstractEmbeddedWrapper(LinkRelation rel) {
            Assert.notNull((Object)rel, (String)"Rel must not be null or empty!");
            this.rel = rel;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.ofNullable(this.rel).filter(it -> !it.equals(NO_REL));
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return this.rel.isSameAs(rel);
        }

        @Override
        @Nullable
        public Class<?> getRelTargetType() {
            Object peek = this.peek();
            Object object = peek = peek instanceof EntityModel ? ((EntityModel)peek).getContent() : peek;
            if (peek == null) {
                return null;
            }
            return AopUtils.getTargetClass((Object)peek);
        }

        @Nullable
        protected abstract Object peek();
    }
}

