/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.annotation.Annotation;
import java.net.URI;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilder {
    private final UriComponents uriComponents;

    private ControllerLinkBuilder(UriComponentsBuilder builder) {
        Assert.notNull((Object)builder);
        this.uriComponents = builder.build();
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        String[] mapping;
        RequestMapping annotation = (RequestMapping)AnnotationUtils.findAnnotation(controller, RequestMapping.class);
        String[] stringArray = mapping = annotation == null ? new String[]{} : (String[])AnnotationUtils.getValue((Annotation)annotation);
        if (mapping.length > 1) {
            throw new IllegalStateException("Multiple controller mappings defined! Unable to build URI!");
        }
        ControllerLinkBuilder builder = new ControllerLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping());
        if (mapping.length == 0) {
            return builder;
        }
        UriTemplate template = new UriTemplate(mapping[0]);
        return builder.slash(template.expand(parameters));
    }

    public ControllerLinkBuilder slash(Object object) {
        if (object == null) {
            return this;
        }
        String[] segments = StringUtils.tokenizeToStringArray((String)object.toString(), (String)"/");
        return new ControllerLinkBuilder(UriComponentsBuilder.fromUri((URI)this.uriComponents.toUri()).pathSegment(segments));
    }

    public ControllerLinkBuilder slash(Identifiable<?> identifyable) {
        if (identifyable == null) {
            return this;
        }
        return this.slash(identifyable.getId());
    }

    public URI toUri() {
        return this.uriComponents.encode().toUri();
    }

    public Link withRel(String rel) {
        return new Link(this.toString(), rel);
    }

    public Link withSelfRel() {
        return new Link(this.toString());
    }

    public String toString() {
        return this.toUri().normalize().toASCIIString();
    }
}

