/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.hateoas.LinkDiscoverers;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.client.Rels;
import org.springframework.hateoas.hal.HalLinkDiscoverer;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class Traverson {
    private static final LinkDiscoverers DEFAULT_LINK_DISCOVERERS;
    private final URI baseUri;
    private final List<MediaType> mediaTypes;
    private RestOperations operations;
    private LinkDiscoverers discoverers;

    public Traverson(URI baseUri, MediaType ... mediaTypes) {
        this(baseUri, Arrays.asList(mediaTypes));
    }

    public Traverson(URI baseUri, List<MediaType> mediaTypes) {
        Assert.notNull((Object)baseUri, (String)"Base URI must not be null!");
        Assert.notEmpty(mediaTypes, (String)"At least one media type must be given!");
        this.mediaTypes = mediaTypes;
        this.baseUri = baseUri;
        this.discoverers = DEFAULT_LINK_DISCOVERERS;
        this.setRestOperations(Traverson.createDefaultTemplate(this.mediaTypes));
    }

    public static List<HttpMessageConverter<?>> getDefaultMessageConverters(MediaType ... mediaTypes) {
        return Traverson.getDefaultMessageConverters(Arrays.asList(mediaTypes));
    }

    public static List<HttpMessageConverter<?>> getDefaultMessageConverters(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"Media types must not be null!");
        ArrayList converters = new ArrayList();
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(Charset.forName("UTF-8")));
        if (mediaTypes.contains(MediaTypes.HAL_JSON)) {
            converters.add(Traverson.getHalConverter());
        }
        return converters;
    }

    private static final RestOperations createDefaultTemplate(List<MediaType> mediaTypes) {
        RestTemplate template = new RestTemplate();
        template.setMessageConverters(Traverson.getDefaultMessageConverters(mediaTypes));
        return template;
    }

    private static final HttpMessageConverter<?> getHalConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(mapper);
        converter.setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON));
        return converter;
    }

    public Traverson setRestOperations(RestOperations operations) {
        this.operations = operations == null ? Traverson.createDefaultTemplate(this.mediaTypes) : operations;
        return this;
    }

    public Traverson setLinkDiscoverers(List<? extends LinkDiscoverer> discoverer) {
        this.discoverers = this.discoverers == null ? DEFAULT_LINK_DISCOVERERS : new LinkDiscoverers((PluginRegistry<LinkDiscoverer, MediaType>)OrderAwarePluginRegistry.create(discoverer));
        return this;
    }

    public TraversalBuilder follow(String ... rels) {
        return new TraversalBuilder().follow(rels);
    }

    private HttpEntity<?> prepareRequest(HttpHeaders headers) {
        HttpHeaders toSend = new HttpHeaders();
        toSend.putAll((Map)headers);
        if (headers.getAccept().isEmpty()) {
            toSend.setAccept(this.mediaTypes);
        }
        return new HttpEntity((MultiValueMap)toSend);
    }

    static {
        HalLinkDiscoverer discoverer = new HalLinkDiscoverer();
        DEFAULT_LINK_DISCOVERERS = new LinkDiscoverers((PluginRegistry<LinkDiscoverer, MediaType>)OrderAwarePluginRegistry.create(Arrays.asList(discoverer)));
    }

    public class TraversalBuilder {
        private List<String> rels = new ArrayList<String>();
        private Map<String, Object> templateParameters = new HashMap<String, Object>();
        private HttpHeaders headers = new HttpHeaders();

        private TraversalBuilder() {
        }

        private TraversalBuilder follow(String ... rels) {
            Assert.notNull((Object)rels, (String)"Rels must not be null!");
            this.rels.addAll(Arrays.asList(rels));
            return this;
        }

        public TraversalBuilder withTemplateParameters(Map<String, Object> parameters) {
            this.templateParameters = parameters;
            return this;
        }

        public TraversalBuilder withHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public <T> T toObject(Class<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            return (T)Traverson.this.operations.exchange(this.traverseToFinalUrl(true), HttpMethod.GET, Traverson.this.prepareRequest(this.headers), type, new Object[0]).getBody();
        }

        public <T> T toObject(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            return (T)Traverson.this.operations.exchange(this.traverseToFinalUrl(true), HttpMethod.GET, Traverson.this.prepareRequest(this.headers), type, new Object[0]).getBody();
        }

        public <T> T toObject(String jsonPath) {
            Assert.hasText((String)jsonPath, (String)"JSON path must not be null or empty!");
            String forObject = (String)Traverson.this.operations.exchange(this.traverseToFinalUrl(true), HttpMethod.GET, Traverson.this.prepareRequest(this.headers), String.class, new Object[0]).getBody();
            return (T)JsonPath.read((String)forObject, (String)jsonPath, (Filter[])new Filter[0]);
        }

        public <T> ResponseEntity<T> toEntity(Class<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            return Traverson.this.operations.exchange(this.traverseToFinalUrl(true), HttpMethod.GET, Traverson.this.prepareRequest(this.headers), type, new Object[0]);
        }

        public Link asLink() {
            return this.traverseToLink(true);
        }

        public Link asTemplatedLink() {
            return this.traverseToLink(false);
        }

        private Link traverseToLink(boolean expandFinalUrl) {
            Assert.isTrue((this.rels.size() > 0 ? 1 : 0) != 0, (String)"At least one rel needs to be provided!");
            return new Link(this.traverseToFinalUrl(expandFinalUrl), this.rels.get(this.rels.size() - 1));
        }

        private String traverseToFinalUrl(boolean expandFinalUrl) {
            String uri = this.getAndFindLinkWithRel(Traverson.this.baseUri.toString(), this.rels.iterator());
            UriTemplate uriTemplate = new UriTemplate(uri);
            return expandFinalUrl ? uriTemplate.expand(this.templateParameters).toString() : uriTemplate.toString();
        }

        private String getAndFindLinkWithRel(String uri, Iterator<String> rels) {
            if (!rels.hasNext()) {
                return uri;
            }
            HttpEntity request = Traverson.this.prepareRequest(this.headers);
            UriTemplate uriTemplate = new UriTemplate(uri);
            ResponseEntity responseEntity = Traverson.this.operations.exchange(uriTemplate.expand(this.templateParameters), HttpMethod.GET, request, String.class);
            MediaType contentType = responseEntity.getHeaders().getContentType();
            String responseBody = (String)responseEntity.getBody();
            Rels.Rel rel = Rels.getRelFor(rels.next(), Traverson.this.discoverers);
            Link link = rel.findInResponse(responseBody, contentType);
            if (link == null) {
                throw new IllegalStateException(String.format("Expected to find link with rel '%s' in response %s!", rel, responseBody));
            }
            return this.getAndFindLinkWithRel(link.getHref(), rels);
        }
    }
}

