/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.util.Assert;

@XmlRootElement(name="entities")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PagedResources<T>
extends Resources<T> {
    @JsonProperty(value="page")
    private PageMetadata metadata;

    protected PagedResources() {
        this(new ArrayList(), (PageMetadata)null, new Link[0]);
    }

    public PagedResources(Collection<T> content, PageMetadata metadata, Link ... links) {
        super(content, links);
        this.metadata = metadata;
    }

    public PageMetadata getMetadata() {
        return this.metadata;
    }

    public static <T extends Resource<S>, S> PagedResources<T> fromEntities(Iterable<S> content, PageMetadata metadata) {
        Assert.notNull(content);
        ArrayList<Resource<S>> resources = new ArrayList<Resource<S>>();
        for (S element : content) {
            resources.add(new Resource<S>(element, new Link[0]));
        }
        return new PagedResources(resources, metadata, new Link[0]);
    }

    @Override
    public String toString() {
        return String.format("PagedResource { content: %s, metadata: %s }", this.getContent(), this.metadata);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PagedResources that = (PagedResources)obj;
        boolean metadataEquals = this.metadata == null ? that.metadata == null : this.metadata.equals(that.metadata);
        return metadataEquals ? super.equals(obj) : false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.metadata == null ? 0 : 31 * this.metadata.hashCode();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class PageMetadata {
        @XmlAttribute
        @JsonProperty
        private long size;
        @XmlAttribute
        @JsonProperty
        private long totalElements;
        @XmlAttribute
        @JsonProperty
        private long totalPages;
        @XmlAttribute
        @JsonProperty
        private long number;

        protected PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            this.size = size;
            this.number = number;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public String toString() {
            return String.format("Metadata { number: %d, total pages: %d, total elements: %d, size: %d }", this.number, this.totalPages, this.totalElements, this.size);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            PageMetadata that = (PageMetadata)obj;
            return this.number == that.number && this.size == that.size && this.totalElements == that.totalElements && this.totalPages == that.totalPages;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * (int)(this.number ^ this.number >>> 32);
            result += 31 * (int)(this.size ^ this.size >>> 32);
            result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
            return result += 31 * (int)(this.totalPages ^ this.totalPages >>> 32);
        }
    }
}

