/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

@XmlRootElement(name="entities")
public class Resources<T>
extends ResourceSupport
implements Iterable<T> {
    @XmlAnyElement
    @XmlElementWrapper
    @JsonProperty(value="content")
    private final Collection<T> content;

    protected Resources() {
        this(new ArrayList(), new Link[0]);
    }

    public Resources(Collection<T> content, Link ... links) {
        Assert.notNull(content);
        this.content = new ArrayList<T>();
        this.content.addAll(content);
        this.add(Arrays.asList(links));
    }

    public static <T extends Resource<S>, S> Resources<T> fromEntities(Iterable<S> content) {
        Assert.notNull(content);
        ArrayList<Resource<S>> resources = new ArrayList<Resource<S>>();
        for (S element : content) {
            resources.add(new Resource<S>(element, new Link[0]));
        }
        return new Resources(resources, new Link[0]);
    }

    public Collection<T> getContent() {
        return this.content;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public String toString() {
        return String.format("Resources { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Resources that = (Resources)obj;
        boolean contentEqual = this.content == null ? that.content == null : ((Object)this.content).equals(that.content);
        return contentEqual ? super.equals(obj) : false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * ((Object)this.content).hashCode();
    }
}

