/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.mvc.UriComponentsLinkBuilder;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilder
extends UriComponentsLinkBuilder<ControllerLinkBuilder> {
    private ControllerLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        String[] mapping;
        Assert.notNull(controller);
        RequestMapping annotation = (RequestMapping)AnnotationUtils.findAnnotation(controller, RequestMapping.class);
        String[] stringArray = mapping = annotation == null ? new String[]{} : (String[])AnnotationUtils.getValue((Annotation)annotation);
        if (mapping.length > 1) {
            throw new IllegalStateException("Multiple controller mappings defined! Unable to build URI!");
        }
        ControllerLinkBuilder builder = new ControllerLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping());
        if (mapping.length == 0) {
            return builder;
        }
        UriTemplate template = new UriTemplate(mapping[0]);
        return (ControllerLinkBuilder)builder.slash(template.expand(parameters));
    }

    @Override
    protected ControllerLinkBuilder getThis() {
        return this;
    }

    @Override
    protected ControllerLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new ControllerLinkBuilder(builder);
    }
}

