/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(parameters);
        return DummyInvocationUtils.getProxyWithInterceptor(type, interceptor);
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, MethodInterceptor interceptor) {
        ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
        if (type.isInterface()) {
            factory.addInterface(type);
        } else {
            factory.setProxyTargetClass(true);
        }
        factory.setTargetClass(type);
        factory.addInterface(LastInvocationAware.class);
        factory.addAdvice((Advice)interceptor);
        return (T)factory.getProxy();
    }

    private static class InvocationRecordingMethodInterceptor
    implements MethodInterceptor,
    LastInvocationAware {
        private static final Method GET_INVOCATIONS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getLastInvocation");
        private static final Method GET_OBJECT_PARAMETERS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getObjectParameters");
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        public InvocationRecordingMethodInterceptor(Object ... parameters) {
            this.objectParameters = (Object[])parameters.clone();
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (GET_INVOCATIONS.equals(method)) {
                return this.getLastInvocation();
            }
            if (GET_OBJECT_PARAMETERS.equals(method)) {
                return this.getObjectParameters();
            }
            if (Object.class.equals(method.getDeclaringClass())) {
                return invocation.proceed();
            }
            this.invocation = invocation;
            Class<?> returnType = method.getReturnType();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this));
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }

    public static interface LastInvocationAware {
        public Iterator<Object> getObjectParameters();

        public MethodInvocation getLastInvocation();
    }
}

