/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.net.URI;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class LinkBuilderSupport<T extends LinkBuilder>
implements LinkBuilder {
    private final UriComponents uriComponents;

    public LinkBuilderSupport(UriComponentsBuilder builder) {
        Assert.notNull((Object)builder);
        this.uriComponents = builder.build();
    }

    public T slash(Object object) {
        if (object == null) {
            return this.getThis();
        }
        if (object instanceof Identifiable) {
            return this.slash((Identifiable)object);
        }
        String[] segments = StringUtils.tokenizeToStringArray((String)object.toString(), (String)"/");
        return this.createNewInstance(UriComponentsBuilder.fromUri((URI)this.uriComponents.toUri()).pathSegment(segments));
    }

    public T slash(Identifiable<?> identifyable) {
        if (identifyable == null) {
            return this.getThis();
        }
        return this.slash(identifyable.getId());
    }

    @Override
    public URI toUri() {
        return this.uriComponents.encode().toUri();
    }

    @Override
    public Link withRel(String rel) {
        return new Link(this.toString(), rel);
    }

    @Override
    public Link withSelfRel() {
        return new Link(this.toString());
    }

    public String toString() {
        return this.toUri().normalize().toASCIIString();
    }

    protected abstract T getThis();

    protected abstract T createNewInstance(UriComponentsBuilder var1);
}

