/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.Assert;

public abstract class ResourceAssemblerSupport<T, D extends ResourceSupport>
implements ResourceAssembler<T, D> {
    private final Class<?> controllerClass;
    private final Class<D> resourceType;

    public ResourceAssemblerSupport(Class<?> controllerClass, Class<D> resourceType) {
        Assert.notNull(controllerClass);
        Assert.notNull(resourceType);
        this.controllerClass = controllerClass;
        this.resourceType = resourceType;
    }

    public List<D> toResources(Iterable<? extends T> entities) {
        Assert.notNull(entities);
        ArrayList result = new ArrayList();
        for (T entity : entities) {
            result.add(this.toResource(entity));
        }
        return result;
    }

    protected D createResourceWithId(Object id, T entity) {
        return this.createResourceWithId(id, entity, new Object[0]);
    }

    protected D createResourceWithId(Object id, T entity, Object ... parameters) {
        Assert.notNull(entity);
        Assert.notNull((Object)id);
        D instance = this.instantiateResource(entity);
        ((ResourceSupport)instance).add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.controllerClass, parameters).slash(id)).withSelfRel());
        return instance;
    }

    protected D instantiateResource(T entity) {
        return (D)((ResourceSupport)BeanUtils.instantiateClass(this.resourceType));
    }
}

