/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.ObjectUtils;

class HalEmbeddedBuilder {
    private static final String DEFAULT_REL = "content";
    private final Map<String, List<Object>> embeddeds = new HashMap<String, List<Object>>();
    private final RelProvider provider;

    public HalEmbeddedBuilder(RelProvider provider) {
        this.provider = provider;
    }

    public void add(Object value) {
        Class<?> type = ObjectUtils.getResourceType(value);
        String singleRel = this.getDefaultedRelFor(type, false);
        List<Object> currentValue = this.embeddeds.get(singleRel);
        if (currentValue == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(value);
            this.embeddeds.put(singleRel, arrayList);
        } else if (currentValue.size() == 1) {
            currentValue.add(value);
            this.embeddeds.remove(singleRel);
            this.embeddeds.put(this.getDefaultedRelFor(type, true), currentValue);
        } else {
            currentValue.add(value);
        }
    }

    private String getDefaultedRelFor(Class<?> type, boolean forCollection) {
        if (this.provider == null) {
            return DEFAULT_REL;
        }
        String rel = forCollection ? this.provider.getCollectionResourceRelFor(type) : this.provider.getSingleResourceRelFor(type);
        return rel == null ? DEFAULT_REL : rel;
    }

    public Map<String, List<Object>> asMap() {
        return Collections.unmodifiableMap(this.embeddeds);
    }
}

