/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodParameter;
import org.springframework.hateoas.MethodLinkBuilderFactory;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.hateoas.mvc.AnnotatedParametersParameterAccessor;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.UriComponentsContributor;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilderFactory
implements MethodLinkBuilderFactory<ControllerLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);
    private static final AnnotatedParametersParameterAccessor PATH_VARIABLE_ACCESSOR = new AnnotatedParametersParameterAccessor(new AnnotationAttribute(PathVariable.class));
    private static final AnnotatedParametersParameterAccessor REQUEST_PARAM_ACCESSOR = new AnnotatedParametersParameterAccessor(new AnnotationAttribute(RequestParam.class));
    private List<UriComponentsContributor> uriComponentsContributors = new ArrayList<UriComponentsContributor>();

    public void setUriComponentsContributors(List<? extends UriComponentsContributor> uriComponentsContributors) {
        this.uriComponentsContributors = Collections.unmodifiableList(uriComponentsContributors);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public ControllerLinkBuilder linkTo(Object invocationValue) {
        Assert.isInstanceOf(DummyInvocationUtils.LastInvocationAware.class, (Object)invocationValue);
        DummyInvocationUtils.LastInvocationAware invocations = (DummyInvocationUtils.LastInvocationAware)invocationValue;
        MethodInvocation invocation = invocations.getLastInvocation();
        Iterator<Object> classMappingParameters = invocations.getObjectParameters();
        Method method = invocation.getMethod();
        String mapping = DISCOVERER.getMapping(method);
        UriComponentsBuilder builder = ControllerLinkBuilder.getBuilder().path(mapping);
        UriTemplate template = new UriTemplate(mapping);
        HashMap<Object, Object> values = new HashMap<Object, Object>();
        Iterator names = template.getVariableNames().iterator();
        while (classMappingParameters.hasNext()) {
            values.put(names.next(), classMappingParameters.next());
        }
        for (AnnotatedParametersParameterAccessor.BoundMethodParameter parameter : PATH_VARIABLE_ACCESSOR.getBoundParameters(invocation)) {
            values.put(parameter.getVariableName(), parameter.asString());
        }
        for (AnnotatedParametersParameterAccessor.BoundMethodParameter parameter : REQUEST_PARAM_ACCESSOR.getBoundParameters(invocation)) {
            Object value = parameter.getValue();
            String key = parameter.getVariableName();
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    builder.queryParam(key, new Object[]{element});
                }
                continue;
            }
            builder.queryParam(key, new Object[]{parameter.asString()});
        }
        UriComponents components = this.applyUriComponentsContributer(builder, invocation).buildAndExpand(values);
        return new ControllerLinkBuilder(UriComponentsBuilder.fromUri((URI)components.toUri()));
    }

    @Override
    public ControllerLinkBuilder linkTo(Method method, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(method, parameters);
    }

    protected UriComponentsBuilder applyUriComponentsContributer(UriComponentsBuilder builder, MethodInvocation invocation) {
        MethodParameters parameters = new MethodParameters(invocation.getMethod());
        Iterator<Object> parameterValues = Arrays.asList(invocation.getArguments()).iterator();
        for (MethodParameter parameter : parameters.getParameters()) {
            Object parameterValue = parameterValues.next();
            for (UriComponentsContributor contributor : this.uriComponentsContributors) {
                if (!contributor.supportsParameter(parameter)) continue;
                contributor.enhance(builder, parameter, parameterValue);
            }
        }
        return builder;
    }
}

