/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

public class MethodParameters {
    private static final ParameterNameDiscoverer DISCOVERER = new LocalVariableTableParameterNameDiscoverer();
    private final List<MethodParameter> parameters;

    public MethodParameters(Method method) {
        Assert.notNull((Object)method);
        this.parameters = new ArrayList<MethodParameter>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            MethodParameter parameter = new MethodParameter(method, i);
            parameter.initParameterNameDiscovery(DISCOVERER);
            this.parameters.add(parameter);
        }
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public List<MethodParameter> getParametersWith(Class<? extends Annotation> annotation) {
        Assert.notNull(annotation);
        ArrayList<MethodParameter> result = new ArrayList<MethodParameter>();
        for (MethodParameter parameter : this.getParameters()) {
            if (!parameter.hasParameterAnnotation(annotation)) continue;
            result.add(parameter);
        }
        return result;
    }
}

