/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class AnnotatedParametersParameterAccessor {
    private final AnnotationAttribute attribute;

    public AnnotatedParametersParameterAccessor(AnnotationAttribute attribute) {
        Assert.notNull((Object)attribute);
        this.attribute = attribute;
    }

    public List<BoundMethodParameter> getBoundParameters(DummyInvocationUtils.MethodInvocation invocation) {
        Assert.notNull((Object)invocation, (String)"MethodInvocation must not be null!");
        MethodParameters parameters = new MethodParameters(invocation.getMethod());
        Object[] arguments = invocation.getArguments();
        ArrayList<BoundMethodParameter> result = new ArrayList<BoundMethodParameter>();
        for (MethodParameter parameter : parameters.getParametersWith(this.attribute.getAnnotationType())) {
            result.add(new BoundMethodParameter(parameter, arguments[parameter.getParameterIndex()], this.attribute));
        }
        return result;
    }

    static class BoundMethodParameter {
        private static final ConversionService CONVERSION_SERVICE = new DefaultFormattingConversionService();
        private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private final MethodParameter parameter;
        private final Object value;
        private final AnnotationAttribute attribute;
        private final TypeDescriptor parameterTypeDecsriptor;

        public BoundMethodParameter(MethodParameter parameter, Object value, AnnotationAttribute attribute) {
            Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
            this.parameter = parameter;
            this.value = value;
            this.attribute = attribute;
            this.parameterTypeDecsriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)0);
        }

        public String getVariableName() {
            if (this.attribute == null) {
                return this.parameter.getParameterName();
            }
            Annotation annotation = this.parameter.getParameterAnnotation(this.attribute.getAnnotationType());
            String annotationAttributeValue = this.attribute.getValueFrom(annotation);
            return StringUtils.hasText((String)annotationAttributeValue) ? annotationAttributeValue : this.parameter.getParameterName();
        }

        public Object getValue() {
            return this.value;
        }

        public String asString() {
            if (this.value == null) {
                return null;
            }
            return (String)CONVERSION_SERVICE.convert(this.value, this.parameterTypeDecsriptor, STRING_DESCRIPTOR);
        }
    }
}

