/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.convert.Property;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.mediatype.TypeBasedPayloadMetadata;
import org.springframework.http.HttpEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PropertyUtils {
    private static final Map<ResolvableType, ResolvableType> DOMAIN_TYPE_CACHE = new ConcurrentReferenceHashMap();
    private static final Map<ResolvableType, AffordanceModel.InputPayloadMetadata> METADATA_CACHE = new ConcurrentReferenceHashMap();
    private static final Set<String> FIELDS_TO_IGNORE = new HashSet<String>(Arrays.asList("class", "links"));
    private static final boolean JSR_303_PRESENT = ClassUtils.isPresent((String)"javax.validation.Valid", (ClassLoader)PropertyUtils.class.getClassLoader());
    private static final List<Class<?>> TYPES_TO_UNWRAP = new ArrayList<Class>(Arrays.asList(EntityModel.class, CollectionModel.class, HttpEntity.class));
    private static final ResolvableType OBJECT_TYPE = ResolvableType.forClass(Object.class);

    public static Map<String, Object> extractPropertyValues(@Nullable Object object) {
        if (object == null) {
            return Collections.emptyMap();
        }
        if (EntityModel.class.isInstance(object)) {
            return PropertyUtils.extractPropertyValues(((EntityModel)EntityModel.class.cast(object)).getContent());
        }
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)object);
        return PropertyUtils.getExposedProperties(object.getClass()).stream().map(AffordanceModel.PropertyMetadata::getName).collect(HashMap::new, (map, name) -> map.put(name, wrapper.getPropertyValue(name)), HashMap::putAll);
    }

    public static <T> T createObjectFromProperties(Class<T> clazz, Map<String, Object> properties) {
        Object obj = BeanUtils.instantiateClass(clazz);
        properties.forEach((key, value) -> Optional.ofNullable(BeanUtils.getPropertyDescriptor((Class)clazz, (String)key)).ifPresent(property -> {
            try {
                Method writeMethod = property.getWriteMethod();
                ReflectionUtils.makeAccessible((Method)writeMethod);
                writeMethod.invoke(obj, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }));
        return (T)obj;
    }

    public static AffordanceModel.InputPayloadMetadata getExposedProperties(@Nullable Class<?> type) {
        return PropertyUtils.getExposedProperties(type == null ? null : ResolvableType.forClass(type));
    }

    public static AffordanceModel.InputPayloadMetadata getExposedProperties(@Nullable ResolvableType type) {
        if (type == null) {
            return AffordanceModel.InputPayloadMetadata.NONE;
        }
        return METADATA_CACHE.computeIfAbsent(type, it -> {
            ResolvableType domainType = PropertyUtils.unwrapDomainType(type);
            Class resolved = domainType.resolve(Object.class);
            return Object.class.equals((Object)resolved) ? AffordanceModel.InputPayloadMetadata.NONE : new TypeBasedPayloadMetadata(domainType, PropertyUtils.lookupExposedProperties(resolved));
        });
    }

    private static ResolvableType unwrapDomainType(ResolvableType type) {
        if (!type.hasGenerics()) {
            return type;
        }
        if (type.hasUnresolvableGenerics()) {
            return PropertyUtils.replaceIfUnwrappable(type, () -> OBJECT_TYPE);
        }
        return DOMAIN_TYPE_CACHE.computeIfAbsent(type, it -> PropertyUtils.replaceIfUnwrappable(it, () -> PropertyUtils.unwrapDomainType(it.getGeneric(new int[]{0}))));
    }

    private static ResolvableType replaceIfUnwrappable(ResolvableType type, Supplier<ResolvableType> mapper) {
        Class resolved = type.resolve(Object.class);
        return TYPES_TO_UNWRAP.stream().anyMatch(it -> it.isAssignableFrom(resolved)) ? mapper.get() : type;
    }

    private static Stream<AffordanceModel.PropertyMetadata> lookupExposedProperties(@Nullable Class<?> type) {
        return type == null ? Stream.empty() : PropertyUtils.getPropertyDescriptors(type).map(it -> new AnnotatedProperty(new Property(type, it.getReadMethod(), it.getWriteMethod()))).map(it -> JSR_303_PRESENT ? new Jsr303AwarePropertyMetadata((AnnotatedProperty)it) : new DefaultPropertyMetadata((AnnotatedProperty)it));
    }

    private static Stream<PropertyDescriptor> getPropertyDescriptors(Class<?> type) {
        return Arrays.stream(BeanUtils.getPropertyDescriptors(type)).filter(descriptor -> !FIELDS_TO_IGNORE.contains(descriptor.getName())).filter(descriptor -> !PropertyUtils.descriptorToBeIgnoredByJackson(type, descriptor)).filter(descriptor -> !PropertyUtils.toBeIgnoredByJackson(type, descriptor.getName())).filter(descriptor -> !PropertyUtils.readerIsToBeIgnoredByJackson(descriptor));
    }

    private static boolean descriptorToBeIgnoredByJackson(Class<?> clazz, PropertyDescriptor descriptor) {
        Field descriptorField = ReflectionUtils.findField(clazz, (String)descriptor.getName());
        return descriptorField == null ? false : PropertyUtils.toBeIgnoredByJackson(MergedAnnotations.from((AnnotatedElement)descriptorField));
    }

    private static boolean readerIsToBeIgnoredByJackson(PropertyDescriptor descriptor) {
        Method reader = descriptor.getReadMethod();
        return reader == null ? false : PropertyUtils.toBeIgnoredByJackson(MergedAnnotations.from((AnnotatedElement)reader));
    }

    private static boolean toBeIgnoredByJackson(MergedAnnotations annotations) {
        return annotations.stream(JsonIgnore.class).findFirst().map(it -> it.getBoolean("value")).orElse(false);
    }

    private static boolean toBeIgnoredByJackson(Class<?> clazz, String field) {
        MergedAnnotations annotations = MergedAnnotations.from(clazz);
        return annotations.stream(JsonIgnoreProperties.class).map(it -> it.getStringArray("value")).flatMap(Arrays::stream).anyMatch(it -> it.equalsIgnoreCase(field));
    }

    static {
        if (ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)PropertyUtils.class.getClassLoader())) {
            TYPES_TO_UNWRAP.addAll(ReactiveWrappers.getTypesToUnwrap());
        }
    }

    private static class Jsr303AwarePropertyMetadata
    extends DefaultPropertyMetadata {
        private final AnnotatedProperty property;

        private Jsr303AwarePropertyMetadata(AnnotatedProperty property) {
            super(property);
            this.property = property;
        }

        @Override
        public boolean isRequired() {
            return super.isRequired() || this.property.getAnnotation(NotNull.class).isPresent();
        }

        @Override
        public Optional<String> getPattern() {
            MergedAnnotation annotation = this.property.getAnnotation(Pattern.class);
            if (annotation.isPresent()) {
                return Jsr303AwarePropertyMetadata.fromAnnotation(annotation);
            }
            annotation = this.property.getTypeAnnotations().get(Pattern.class);
            return annotation.isPresent() ? Jsr303AwarePropertyMetadata.fromAnnotation((MergedAnnotation<Pattern>)annotation) : Optional.empty();
        }

        private static Optional<String> fromAnnotation(MergedAnnotation<Pattern> annotation) {
            return Optional.of(annotation.getString("regexp")).filter(StringUtils::hasText);
        }
    }

    private static class DefaultPropertyMetadata
    implements AffordanceModel.PropertyMetadata,
    Comparable<DefaultPropertyMetadata> {
        private static Comparator<AffordanceModel.PropertyMetadata> BY_NAME = Comparator.comparing(AffordanceModel.PropertyMetadata::getName);
        private final AnnotatedProperty property;

        @Override
        public String getName() {
            return this.property.getName();
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            if (!this.property.hasWriteMethod()) {
                return true;
            }
            MergedAnnotation<JsonProperty> annotation = this.property.getAnnotation(JsonProperty.class);
            return !annotation.isPresent() ? false : JsonProperty.Access.READ_ONLY.equals((Object)annotation.getEnum("access", JsonProperty.Access.class));
        }

        @Override
        public Optional<String> getPattern() {
            return Optional.empty();
        }

        @Override
        public ResolvableType getType() {
            return this.property.getType();
        }

        @Override
        public int compareTo(DefaultPropertyMetadata that) {
            return BY_NAME.compare(this, that);
        }

        @Generated
        private DefaultPropertyMetadata(AnnotatedProperty property) {
            this.property = property;
        }
    }

    private static class AnnotatedProperty {
        private final Map<Class<?>, MergedAnnotation<?>> annotationCache = new ConcurrentReferenceHashMap();
        private final Property property;
        private final ResolvableType type;
        private final List<MergedAnnotations> annotations;
        private final MergedAnnotations typeAnnotations;

        public AnnotatedProperty(Property property) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            this.property = property;
            Field field = ReflectionUtils.findField((Class)property.getObjectType(), (String)property.getName());
            this.type = (ResolvableType)AnnotatedProperty.firstNonEmpty(() -> Optional.ofNullable(property.getReadMethod()).map(ResolvableType::forMethodReturnType), () -> Optional.ofNullable(property.getWriteMethod()).map(it -> ResolvableType.forMethodParameter((Method)it, (int)0)), () -> Optional.ofNullable(field).map(ResolvableType::forField));
            this.annotations = Stream.of(property.getReadMethod(), property.getWriteMethod(), field).filter(it -> it != null).map(MergedAnnotations::from).collect(Collectors.toList());
            this.typeAnnotations = MergedAnnotations.from((AnnotatedElement)this.type.resolve(Object.class));
        }

        private static <T> T firstNonEmpty(Supplier<Optional<T>> ... suppliers) {
            Assert.notNull(suppliers, (String)"Suppliers must not be null!");
            return (T)Stream.of(suppliers).map(Supplier::get).flatMap(it -> it.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElseThrow(() -> new IllegalStateException("Could not resolve value!"));
        }

        public String getName() {
            return this.property.getName();
        }

        public ResolvableType getType() {
            return this.type;
        }

        public MergedAnnotations getTypeAnnotations() {
            return this.typeAnnotations;
        }

        public boolean hasWriteMethod() {
            return this.property.getWriteMethod() != null;
        }

        public <T extends Annotation> MergedAnnotation<T> getAnnotation(Class<T> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return this.annotationCache.computeIfAbsent(type, it -> this.lookupAnnotation(type));
        }

        private <T extends Annotation> MergedAnnotation<T> lookupAnnotation(Class<T> type) {
            return this.annotations.stream().map(it -> it.get(type)).filter(it -> it != null && it.isPresent()).findFirst().orElse(MergedAnnotation.missing());
        }
    }

    private static class ReactiveWrappers {
        private ReactiveWrappers() {
        }

        static List<Class<?>> getTypesToUnwrap() {
            return Arrays.asList(Publisher.class);
        }
    }
}

