/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class TemplateVariables
implements Iterable<TemplateVariable>,
Serializable {
    public static final TemplateVariables NONE = new TemplateVariables(new TemplateVariable[0]);
    private static final long serialVersionUID = -7736592281223783079L;
    private final List<TemplateVariable> variables;

    public TemplateVariables(TemplateVariable ... variables) {
        this(Arrays.asList(variables));
    }

    public TemplateVariables(List<TemplateVariable> variables) {
        Assert.notNull(variables, (String)"Template variables must not be null!");
        Assert.noNullElements((Object[])variables.toArray(), (String)"Variables must not contain null values!");
        this.variables = Collections.unmodifiableList(variables);
    }

    public TemplateVariables concat(TemplateVariable ... variables) {
        return this.concat(Arrays.asList(variables));
    }

    public TemplateVariables concat(Collection<TemplateVariable> variables) {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>(this.variables.size() + variables.size());
        result.addAll(this.variables);
        List filtered = variables.stream().filter(variable -> !this.containsEquivalentFor((TemplateVariable)variable)).collect(Collectors.toList());
        result.addAll(filtered);
        return new TemplateVariables(result);
    }

    public TemplateVariables concat(TemplateVariables variables) {
        return this.concat(variables.variables);
    }

    public List<TemplateVariable> asList() {
        return this.variables;
    }

    private boolean containsEquivalentFor(TemplateVariable candidate) {
        return this.variables.stream().anyMatch(variable -> variable.isEquivalent(candidate));
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean appended) {
        if (this.variables.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        TemplateVariable previous = null;
        for (TemplateVariable variable : this.variables) {
            TemplateVariable.VariableType type = variable.getType();
            TemplateVariable.VariableType variableType = type = appended && type.equals((Object)TemplateVariable.VariableType.REQUEST_PARAM) ? TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED : type;
            if (previous == null) {
                builder.append("{").append(type.toString());
            } else if (!previous.isCombinable(variable)) {
                builder.append("}{").append(type.toString());
            } else {
                builder.append(",");
            }
            previous = variable;
            builder.append(variable.getName());
        }
        return builder.append("}").toString();
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateVariables)) {
            return false;
        }
        TemplateVariables other = (TemplateVariables)o;
        List<TemplateVariable> this$variables = this.variables;
        List<TemplateVariable> other$variables = other.variables;
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TemplateVariable> $variables = this.variables;
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }
}

