/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.util.Assert;

public class TypedEntityLinks<T> {
    @NonNull
    private final Function<T, ?> identifierExtractor;
    @NonNull
    private final EntityLinks entityLinks;

    public LinkBuilder linkForItemResource(T entity) {
        return this.entityLinks.linkForItemResource(entity.getClass(), this.identifierExtractor.apply(entity));
    }

    public Link linkToItemResource(T entity) {
        return this.entityLinks.linkToItemResource(entity.getClass(), this.identifierExtractor.apply(entity));
    }

    @Generated
    TypedEntityLinks(@NonNull Function<T, ?> identifierExtractor, @NonNull EntityLinks entityLinks) {
        if (identifierExtractor == null) {
            throw new IllegalArgumentException("identifierExtractor is marked non-null but is null");
        }
        if (entityLinks == null) {
            throw new IllegalArgumentException("entityLinks is marked non-null but is null");
        }
        this.identifierExtractor = identifierExtractor;
        this.entityLinks = entityLinks;
    }

    public static class ExtendedTypedEntityLinks<T>
    extends TypedEntityLinks<T> {
        private final Class<T> type;
        private final EntityLinks delegate;

        ExtendedTypedEntityLinks(Function<T, ?> identifierExtractor, EntityLinks delegate, Class<T> type) {
            super(identifierExtractor, delegate);
            Assert.notNull(type, (String)"Type must not be null!");
            this.type = type;
            this.delegate = delegate;
        }

        public Link linkToCollectionResource() {
            return this.delegate.linkToCollectionResource(this.type);
        }
    }
}

