/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
final class HalFormsProperty
implements AffordanceModel.PropertyMetadataConfigured<HalFormsProperty>,
AffordanceModel.Named {
    private final String name;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean readOnly;
    private final String value;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String prompt;
    private final String regex;
    private final boolean templated;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean required;
    private final boolean multi;

    HalFormsProperty() {
        this.name = null;
        this.readOnly = false;
        this.value = null;
        this.prompt = null;
        this.regex = null;
        this.templated = false;
        this.required = false;
        this.multi = false;
    }

    private HalFormsProperty(String name, boolean readOnly, String value, String prompt, String regex, boolean templated, boolean required, boolean multi) {
        Assert.notNull((Object)name, (String)"name must not be null!");
        this.name = name;
        this.readOnly = readOnly;
        this.value = value;
        this.prompt = prompt;
        this.regex = regex;
        this.templated = templated;
        this.required = required;
        this.multi = multi;
    }

    static HalFormsProperty named(String name) {
        return new HalFormsProperty().withName(name);
    }

    @Override
    public HalFormsProperty apply(AffordanceModel.PropertyMetadata metadata) {
        HalFormsProperty customized = this.withRequired(metadata.isRequired()).withReadOnly(metadata.isReadOnly());
        return metadata.getPattern().map(customized::withRegex).orElse(customized);
    }

    HalFormsProperty withName(String name) {
        Assert.notNull((Object)name, (String)"name must not be null!");
        return this.name == name ? this : new HalFormsProperty(name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi);
    }

    HalFormsProperty withReadOnly(boolean readOnly) {
        return this.readOnly == readOnly ? this : new HalFormsProperty(this.name, readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi);
    }

    HalFormsProperty withValue(String value) {
        return this.value == value ? this : new HalFormsProperty(this.name, this.readOnly, value, this.prompt, this.regex, this.templated, this.required, this.multi);
    }

    HalFormsProperty withPrompt(String prompt) {
        return this.prompt == prompt ? this : new HalFormsProperty(this.name, this.readOnly, this.value, prompt, this.regex, this.templated, this.required, this.multi);
    }

    HalFormsProperty withRegex(String regex) {
        return this.regex == regex ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, regex, this.templated, this.required, this.multi);
    }

    HalFormsProperty withTemplated(boolean templated) {
        return this.templated == templated ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, templated, this.required, this.multi);
    }

    HalFormsProperty withRequired(boolean required) {
        return this.required == required ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, required, this.multi);
    }

    HalFormsProperty withMulti(boolean multi) {
        return this.multi == multi ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, multi);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    boolean isReadOnly() {
        return this.readOnly;
    }

    @JsonProperty
    String getValue() {
        return this.value;
    }

    @JsonProperty
    String getPrompt() {
        return this.prompt;
    }

    @JsonProperty
    String getRegex() {
        return this.regex;
    }

    @JsonProperty
    boolean isTemplated() {
        return this.templated;
    }

    @JsonProperty
    boolean isRequired() {
        return this.required;
    }

    @JsonProperty
    boolean isMulti() {
        return this.multi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsProperty)) {
            return false;
        }
        HalFormsProperty that = (HalFormsProperty)o;
        return this.readOnly == that.readOnly && this.templated == that.templated && this.required == that.required && this.multi == that.multi && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.regex, that.regex);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi);
    }

    public String toString() {
        return "HalFormsProperty(name=" + this.name + ", readOnly=" + this.readOnly + ", value=" + this.value + ", prompt=" + this.prompt + ", regex=" + this.regex + ", templated=" + this.templated + ", required=" + this.required + ", multi=" + this.multi + ")";
    }
}

