/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplatePropertyWriter;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.http.MediaType;

@Configuration(proxyBeanMethods=false)
class HalFormsMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final DelegatingLinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalFormsConfiguration> halFormsConfiguration;
    private final ObjectProvider<HalConfiguration> halConfiguration;
    private final MessageResolver resolver;
    private final AbstractAutowireCapableBeanFactory beanFactory;
    private HalFormsConfiguration resolvedConfiguration;

    public HalFormsMediaTypeConfiguration(DelegatingLinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalFormsConfiguration> halFormsConfiguration, ObjectProvider<HalConfiguration> halConfiguration, MessageResolver resolver, AbstractAutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halFormsConfiguration = halFormsConfiguration;
        this.halConfiguration = halConfiguration;
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }

    @Bean
    LinkDiscoverer halFormsLinkDiscoverer() {
        return new HalFormsLinkDiscoverer();
    }

    @Bean
    HalFormsTemplatePropertyWriter halFormsTemplatePropertyWriter() {
        HalFormsConfiguration configuration = this.getResolvedConfiguration();
        HalFormsTemplateBuilder builder = new HalFormsTemplateBuilder(configuration, this.resolver);
        return new HalFormsTemplatePropertyWriter(builder);
    }

    @Override
    public ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        HalFormsConfiguration halFormsConfig = this.getResolvedConfiguration();
        CurieProvider provider = (CurieProvider)this.curieProvider.getIfAvailable(() -> CurieProvider.NONE);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new Jackson2HalFormsModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)new Jackson2HalModule.HalHandlerInstantiator(this.relProvider, provider, this.resolver, halFormsConfig.getHalConfiguration(), (AutowireCapableBeanFactory)this.beanFactory));
        halFormsConfig.customize(mapper);
        return mapper;
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return EnableHypermediaSupport.HypermediaType.HAL_FORMS.getMediaTypes();
    }

    HalFormsConfiguration getResolvedConfiguration() {
        Supplier<HalFormsConfiguration> defaultConfig = () -> new HalFormsConfiguration((HalConfiguration)this.halConfiguration.getIfAvailable(HalConfiguration::new));
        if (this.resolvedConfiguration == null) {
            this.resolvedConfiguration = (HalFormsConfiguration)this.halFormsConfiguration.getIfAvailable(defaultConfig);
        }
        return this.resolvedConfiguration;
    }
}

