/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.LinkParser;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.UriTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"templated", "template"}, ignoreUnknown=true)
public class Link
implements Serializable {
    private static final long serialVersionUID = -9037755944661782121L;
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    private LinkRelation rel;
    private String href;
    @Nullable
    private String hreflang;
    @Nullable
    private String media;
    @Nullable
    private String title;
    @Nullable
    private String type;
    @Nullable
    private String deprecation;
    @Nullable
    private String profile;
    @Nullable
    private String name;
    @JsonIgnore
    @Nullable
    private UriTemplate template;
    @JsonIgnore
    private List<Affordance> affordances;

    protected Link(String href, LinkRelation rel) {
        this(href, Link.templateOrNull(href), rel, Collections.emptyList());
    }

    protected Link(UriTemplate template, LinkRelation rel) {
        this(template, rel, Collections.emptyList());
    }

    private Link(UriTemplate template, LinkRelation rel, List<Affordance> affordances) {
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.notNull((Object)rel, (String)"LinkRelation must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.template = template;
        this.rel = rel;
        this.href = template.toString();
        this.affordances = affordances;
    }

    private Link(String href, @Nullable UriTemplate template, LinkRelation rel, List<Affordance> affordances) {
        Assert.hasText((String)href, (String)"Href must not be null or empty!");
        Assert.notNull((Object)rel, (String)"LinkRelation must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.href = href;
        this.template = template;
        this.rel = rel;
        this.affordances = affordances;
    }

    Link(LinkRelation rel, String href, @Nullable String hreflang, @Nullable String media, @Nullable String title, @Nullable String type, @Nullable String deprecation, @Nullable String profile, @Nullable String name, @Nullable UriTemplate template, List<Affordance> affordances) {
        this.rel = rel;
        this.href = href;
        this.hreflang = hreflang;
        this.media = media;
        this.title = title;
        this.type = type;
        this.deprecation = deprecation;
        this.profile = profile;
        this.name = name;
        this.template = template;
        this.affordances = affordances;
    }

    public static Link of(String href) {
        return new Link(href, IanaLinkRelations.SELF);
    }

    public static Link of(String href, String relation) {
        return new Link(href, LinkRelation.of(relation));
    }

    public static Link of(String href, LinkRelation relation) {
        return new Link(href, relation);
    }

    public static Link of(UriTemplate template, String relation) {
        return new Link(template, LinkRelation.of(relation));
    }

    public static Link of(UriTemplate template, LinkRelation relation) {
        return new Link(template, relation);
    }

    protected Link() {
        this.affordances = new ArrayList<Affordance>();
    }

    public List<Affordance> getAffordances() {
        return Collections.unmodifiableList(this.affordances);
    }

    public Link withSelfRel() {
        return this.withRel(IanaLinkRelations.SELF);
    }

    public Link andAffordance(Affordance affordance) {
        Assert.notNull((Object)affordance, (String)"Affordance must not be null!");
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>(this.affordances);
        newAffordances.add(affordance);
        return this.withAffordances(newAffordances);
    }

    public Link andAffordances(List<Affordance> affordances) {
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>();
        newAffordances.addAll(this.affordances);
        newAffordances.addAll(affordances);
        return this.withAffordances(newAffordances);
    }

    public Link withAffordances(List<Affordance> affordances) {
        return new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, affordances);
    }

    @JsonIgnore
    public List<String> getVariableNames() {
        UriTemplate template = this.template;
        return template == null ? Collections.emptyList() : template.getVariableNames();
    }

    @JsonIgnore
    public List<TemplateVariable> getVariables() {
        UriTemplate template = this.template;
        return template == null ? Collections.emptyList() : template.getVariables();
    }

    public boolean isTemplated() {
        UriTemplate template = this.template;
        return template == null ? false : !template.getVariables().isEmpty();
    }

    public Link expand(Object ... arguments) {
        UriTemplate template = this.template;
        return template == null ? this : Link.of(template.expand(arguments).toString(), this.getRel());
    }

    public Link expand(Map<String, ?> arguments) {
        UriTemplate template = this.template;
        return template == null ? this : Link.of(template.expand(arguments).toString(), this.getRel());
    }

    public Link withRel(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        return new Link(relation, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withRel(String relation) {
        return this.withRel(LinkRelation.of(relation));
    }

    public boolean hasRel(String rel) {
        Assert.hasText((String)rel, (String)"Link relation must not be null or empty!");
        return this.hasRel(LinkRelation.of(rel));
    }

    public boolean hasRel(LinkRelation rel) {
        Assert.notNull((Object)rel, (String)"Link relation must not be null!");
        return this.rel.isSameAs(rel);
    }

    public URI toUri() {
        try {
            return URI.create(this.expand(new Object[0]).getHref());
        }
        catch (IllegalArgumentException o_O) {
            throw new IllegalStateException(o_O);
        }
    }

    public static Link valueOf(String source) {
        return LinkParser.parseLink(source, new int[]{0});
    }

    public Link withHref(String href) {
        return this.href == href ? this : new Link(this.rel, href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withHreflang(String hreflang) {
        return this.hreflang == hreflang ? this : new Link(this.rel, this.href, hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withMedia(String media) {
        return this.media == media ? this : new Link(this.rel, this.href, this.hreflang, media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withTitle(String title) {
        return this.title == title ? this : new Link(this.rel, this.href, this.hreflang, this.media, title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withType(String type) {
        return this.type == type ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withDeprecation(String deprecation) {
        return this.deprecation == deprecation ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withProfile(String profile) {
        return this.profile == profile ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, profile, this.name, this.template, this.affordances);
    }

    public Link withName(String name) {
        return this.name == name ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, name, this.template, this.affordances);
    }

    @JsonProperty
    public LinkRelation getRel() {
        return this.rel;
    }

    @JsonProperty
    public String getHref() {
        return this.href;
    }

    @Nullable
    @JsonProperty
    public String getHreflang() {
        return this.hreflang;
    }

    @Nullable
    @JsonProperty
    public String getMedia() {
        return this.media;
    }

    @Nullable
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Nullable
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getDeprecation() {
        return this.deprecation;
    }

    @Nullable
    @JsonProperty
    public String getProfile() {
        return this.profile;
    }

    @Nullable
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public UriTemplate getTemplate() {
        UriTemplate template = this.template;
        return template == null ? UriTemplate.of(this.href) : template;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.rel, link.rel) && Objects.equals(this.href, link.href) && Objects.equals(this.hreflang, link.hreflang) && Objects.equals(this.media, link.media) && Objects.equals(this.title, link.title) && Objects.equals(this.type, link.type) && Objects.equals(this.deprecation, link.deprecation) && Objects.equals(this.profile, link.profile) && Objects.equals(this.name, link.name) && Objects.equals(this.affordances, link.affordances);
    }

    public int hashCode() {
        return Objects.hash(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.affordances);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append('<').append(this.href.replace(">", "%3e")).append(">;rel=");
        Link.quoteParamValue(this.rel.value(), result);
        if (this.hreflang != null) {
            result.append(";hreflang=");
            Link.quoteParamValue(this.hreflang, result);
        }
        if (this.media != null) {
            result.append(";media=");
            Link.quoteParamValue(this.media, result);
        }
        if (this.title != null) {
            result.append(";title=");
            Link.quoteParamValue(this.title, result);
        }
        if (this.type != null) {
            result.append(";type=");
            Link.quoteParamValue(this.type, result);
        }
        if (this.deprecation != null) {
            result.append(";deprecation=");
            Link.quoteParamValue(this.deprecation, result);
        }
        if (this.profile != null) {
            result.append(";profile=");
            Link.quoteParamValue(this.profile, result);
        }
        if (this.name != null) {
            result.append(";name=");
            Link.quoteParamValue(this.name, result);
        }
        return result.toString();
    }

    private static void quoteParamValue(String s, StringBuilder target) {
        target.ensureCapacity(target.length() + s.length() + 4);
        target.append('\"');
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if (ch == '\"' || ch == '\\') {
                target.append('\\');
            }
            target.append(ch);
        }
        target.append('\"');
    }

    @Nullable
    static UriTemplate templateOrNull(String href) {
        Assert.notNull((Object)href, (String)"Href must not be null!");
        return href.contains("{") ? UriTemplate.of(href) : null;
    }
}

