/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Objects;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.Resolved;

public interface SchemaResolver {
    default public <T> Resolved<Schema<T>> resolveSchema(@Nullable T message) {
        return this.resolveSchema(message == null ? null : message.getClass());
    }

    default public <T> Resolved<Schema<T>> resolveSchema(@Nullable Class<?> messageType) {
        return this.resolveSchema(messageType, true);
    }

    public <T> Resolved<Schema<T>> resolveSchema(@Nullable Class<?> var1, boolean var2);

    public <T> Resolved<Schema<T>> resolveSchema(SchemaType var1, @Nullable ResolvableType var2);

    default public <T> Resolved<Schema<T>> resolveSchema(SchemaType schemaType, @Nullable Class<?> messageType, @Nullable Class<?> messageKeyType) {
        Objects.requireNonNull(schemaType, "schemaType must not be null");
        ResolvableType resolvableType = null;
        if (schemaType.isStruct()) {
            if (messageType == null) {
                return Resolved.failed("messageType must be specified for %s schema type".formatted(schemaType.name()));
            }
            resolvableType = ResolvableType.forClass(messageType);
        } else if (schemaType == SchemaType.KEY_VALUE) {
            if (messageType == null) {
                return Resolved.failed("messageType must be specified for KEY_VALUE schema type");
            }
            if (messageKeyType == null) {
                return Resolved.failed("messageKeyType must be specified for KEY_VALUE schema type");
            }
            resolvableType = ResolvableType.forClassWithGenerics(KeyValue.class, (Class[])new Class[]{messageKeyType, messageType});
        } else if (schemaType == SchemaType.NONE) {
            if (messageType != null && messageKeyType != null) {
                resolvableType = ResolvableType.forClassWithGenerics(KeyValue.class, (Class[])new Class[]{messageKeyType, messageType});
            } else if (messageType != null) {
                resolvableType = ResolvableType.forClass(messageType);
            }
        }
        return this.resolveSchema(schemaType, resolvableType);
    }

    @FunctionalInterface
    public static interface SchemaResolverCustomizer<T extends SchemaResolver> {
        public void customize(T var1);
    }
}

