/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.config.AbstractPulsarListenerEndpoint;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarBatchMessagesToSpringMessageListenerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarRecordMessageToSpringMessageListenerAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MethodPulsarListenerEndpoint<V>
extends AbstractPulsarListenerEndpoint<V> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private SmartMessageConverter messagingConverter;
    private RedeliveryBackoff negativeAckRedeliveryBackoff;
    private RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    private DeadLetterPolicy deadLetterPolicy;
    private PulsarConsumerErrorHandler pulsarConsumerErrorHandler;
    private ConsumerBuilderCustomizer<?> consumerBuilderCustomizer;
    private Boolean transactional;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Override
    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListener(PulsarMessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        boolean hasTopicInfo;
        SchemaInfo schemaInfo;
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        AbstractPulsarMessageToSpringMessageAdapter<V> messageListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(messageListener);
        messageListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.getInvokerHandlerMethod().getMethodParameters();
        MethodParameter messageParameter = null;
        Optional<MethodParameter> parameter = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) || !methodParameter1.getParameterType().equals(Acknowledgement.class) || !methodParameter1.hasParameterAnnotation(Header.class)).findFirst();
        long count = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) && !methodParameter1.getParameterType().equals(Acknowledgement.class) && !methodParameter1.hasParameterAnnotation(Header.class)).count();
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"More than 1 expected payload types found");
        if (parameter.isPresent()) {
            messageParameter = parameter.get();
        }
        ConcurrentPulsarMessageListenerContainer containerInstance = (ConcurrentPulsarMessageListenerContainer)container;
        PulsarContainerProperties pulsarContainerProperties = containerInstance.getContainerProperties();
        SchemaResolver schemaResolver = pulsarContainerProperties.getSchemaResolver();
        SchemaType schemaType = pulsarContainerProperties.getSchemaType();
        ResolvableType messageType = this.resolvableType(messageParameter);
        schemaResolver.resolveSchema(schemaType, messageType).ifResolvedOrElse(pulsarContainerProperties::setSchema, ex -> this.logger.warn(() -> "Failed to resolve schema for type %s - will default to BYTES (due to: %s)".formatted(schemaType, ex.getMessage())));
        if (pulsarContainerProperties.getSchema() != null && (schemaInfo = pulsarContainerProperties.getSchema().getSchemaInfo()) != null) {
            pulsarContainerProperties.setSchemaType(schemaInfo.getType());
        }
        TopicResolver topicResolver = pulsarContainerProperties.getTopicResolver();
        boolean bl = hasTopicInfo = !ObjectUtils.isEmpty(pulsarContainerProperties.getTopics()) || StringUtils.hasText((String)pulsarContainerProperties.getTopicsPattern());
        if (!hasTopicInfo) {
            topicResolver.resolveTopic((String)null, messageType.getRawClass(), () -> null).ifResolved(topic -> pulsarContainerProperties.setTopics(Set.of(topic)));
        }
        this.validateAndAdjustTransactionSettings(pulsarContainerProperties.transactions());
        container.setNegativeAckRedeliveryBackoff(this.negativeAckRedeliveryBackoff);
        container.setAckTimeoutRedeliveryBackoff(this.ackTimeoutRedeliveryBackoff);
        container.setDeadLetterPolicy(this.deadLetterPolicy);
        container.setPulsarConsumerErrorHandler(this.pulsarConsumerErrorHandler);
        container.setConsumerCustomizer(this.consumerBuilderCustomizer);
        return messageListener;
    }

    private void validateAndAdjustTransactionSettings(PulsarContainerProperties.TransactionSettings txnProps) {
        if (this.transactional == null) {
            return;
        }
        Assert.state((!txnProps.isRequired() || this.transactional != false ? 1 : 0) != 0, (String)"Listener w/ id [%s] requested no transactions but txn are required".formatted(this.getId()));
        if (!this.transactional.booleanValue()) {
            this.logger.debug(() -> "Listener w/ id [%s] requested no transactions".formatted(this.getId()));
            txnProps.setEnabled(false);
        } else if (txnProps.getTransactionManager() == null) {
            this.logger.warn(() -> "Listener w/ id [%s] requested transactions but no txn mgr available".formatted(this.getId()));
        } else {
            txnProps.setEnabled(true);
        }
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (resolvableType.getRawClass() != null && (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass()))) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(AbstractPulsarMessageToSpringMessageAdapter<V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        AbstractPulsarMessageToSpringMessageAdapter listener;
        if (this.isBatchListener()) {
            listener = messageListener = new PulsarBatchMessagesToSpringMessageListenerAdapter(this.bean, this.method);
        } else {
            messageListener = new PulsarRecordMessageToSpringMessageListenerAdapter(this.bean, this.method);
            if (messageConverter instanceof PulsarMessageConverter) {
                messageListener.setMessageConverter((PulsarMessageConverter)messageConverter);
            }
            listener = messageListener;
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public void setPulsarConsumerErrorHandler(PulsarConsumerErrorHandler pulsarConsumerErrorHandler) {
        this.pulsarConsumerErrorHandler = pulsarConsumerErrorHandler;
    }

    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
    }

    public ConsumerBuilderCustomizer<?> getConsumerBuilderCustomizer() {
        return this.consumerBuilderCustomizer;
    }

    public void setConsumerBuilderCustomizer(ConsumerBuilderCustomizer<?> consumerBuilderCustomizer) {
        this.consumerBuilderCustomizer = consumerBuilderCustomizer;
    }

    public Boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(Boolean transactional) {
        this.transactional = transactional;
    }
}

