/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarConsumerFactory<T>
implements PulsarConsumerFactory<T> {
    private final PulsarClient pulsarClient;
    @Nullable
    private final List<ConsumerBuilderCustomizer<T>> defaultConfigCustomizers;

    public DefaultPulsarConsumerFactory(PulsarClient pulsarClient, List<ConsumerBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.pulsarClient = pulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics, @Nullable String subscriptionName, ConsumerBuilderCustomizer<T> customizer) {
        try {
            return this.createConsumer(schema, topics, subscriptionName, null, customizer != null ? Collections.singletonList(customizer) : null);
        }
        catch (PulsarException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PulsarException(PulsarClientException.unwrap((Throwable)ex));
        }
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics, @Nullable String subscriptionName, @Nullable Map<String, String> metadataProperties, @Nullable List<ConsumerBuilderCustomizer<T>> customizers) {
        Objects.requireNonNull(schema, "Schema must be specified");
        ConsumerBuilder consumerBuilder = this.pulsarClient.newConsumer(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        if (topics != null) {
            this.replaceTopicsOnBuilder(consumerBuilder, topics);
        }
        if (subscriptionName != null) {
            consumerBuilder.subscriptionName(subscriptionName);
        }
        if (metadataProperties != null) {
            this.replaceMetadataPropertiesOnBuilder(consumerBuilder, metadataProperties);
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        try {
            return consumerBuilder.subscribe();
        }
        catch (PulsarClientException ex) {
            throw new PulsarException(ex);
        }
    }

    private void replaceTopicsOnBuilder(ConsumerBuilder<T> builder, Collection<String> topics) {
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        builderImpl.getConf().setTopicNames(new HashSet<String>(topics));
    }

    private void replaceMetadataPropertiesOnBuilder(ConsumerBuilder<T> builder, Map<String, String> metadataProperties) {
        ConsumerBuilderImpl builderImpl = (ConsumerBuilderImpl)builder;
        builderImpl.getConf().setProperties(new TreeMap<String, String>(metadataProperties));
    }
}

