/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ReaderBuilderImpl;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarReaderFactory<T>
implements PulsarReaderFactory<T> {
    private final PulsarClient pulsarClient;
    @Nullable
    private final List<ReaderBuilderCustomizer<T>> defaultConfigCustomizers;

    public DefaultPulsarReaderFactory(PulsarClient pulsarClient) {
        this(pulsarClient, null);
    }

    public DefaultPulsarReaderFactory(PulsarClient pulsarClient, @Nullable List<ReaderBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.pulsarClient = pulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    @Override
    public Reader<T> createReader(@Nullable List<String> topics, @Nullable MessageId messageId, Schema<T> schema, @Nullable List<ReaderBuilderCustomizer<T>> customizers) throws PulsarClientException {
        Objects.requireNonNull(schema, "Schema must be specified");
        ReaderBuilder readerBuilder = this.pulsarClient.newReader(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(readerBuilder));
        }
        if (!CollectionUtils.isEmpty(topics)) {
            this.replaceTopicsOnBuilder(readerBuilder, topics);
        }
        if (messageId != null) {
            readerBuilder.startMessageId(messageId);
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(customizer -> customizer.customize(readerBuilder));
        }
        return readerBuilder.create();
    }

    private void replaceTopicsOnBuilder(ReaderBuilder<T> builder, Collection<String> topics) {
        ReaderBuilderImpl builderImpl = (ReaderBuilderImpl)builder;
        builderImpl.getConf().setTopicNames(new HashSet<String>(topics));
    }
}

