/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.asciidoctor;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Supplier;

class SnippetsDirectoryResolver {
    SnippetsDirectoryResolver() {
    }

    File getSnippetsDirectory(Map<String, Object> attributes) {
        if (System.getProperty("maven.home") != null) {
            return this.getMavenSnippetsDirectory(attributes);
        }
        return this.getGradleSnippetsDirectory(attributes);
    }

    private File getMavenSnippetsDirectory(Map<String, Object> attributes) {
        Path docdir = Paths.get(this.getRequiredAttribute(attributes, "docdir"), new String[0]);
        return new File(docdir.relativize(this.findPom(docdir).getParent()).toFile(), "target/generated-snippets");
    }

    private Path findPom(Path docdir) {
        for (Path path = docdir; path != null; path = path.getParent()) {
            Path pom = path.resolve("pom.xml");
            if (!Files.isRegularFile(pom, new LinkOption[0])) continue;
            return pom;
        }
        throw new IllegalStateException("pom.xml not found in '" + docdir + "' or above");
    }

    private File getGradleSnippetsDirectory(Map<String, Object> attributes) {
        return new File(this.getRequiredAttribute(attributes, "gradle-projectdir", () -> this.getRequiredAttribute(attributes, "projectdir")), "build/generated-snippets");
    }

    private String getRequiredAttribute(Map<String, Object> attributes, String name) {
        return this.getRequiredAttribute(attributes, name, null);
    }

    private String getRequiredAttribute(Map<String, Object> attributes, String name, Supplier<String> fallback) {
        String attribute = (String)attributes.get(name);
        if (attribute == null || attribute.length() == 0) {
            if (fallback != null) {
                return fallback.get();
            }
            throw new IllegalStateException(name + " attribute not found");
        }
        return attribute;
    }
}

