/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public final class RestDocumentationContext {
    private final AtomicInteger stepCount = new AtomicInteger(0);
    private final Class<?> testClass;
    private final String testMethodName;
    private final File outputDirectory;

    public RestDocumentationContext(Class<?> testClass, String testMethodName, File outputDirectory) {
        this.testClass = testClass;
        this.testMethodName = testMethodName;
        this.outputDirectory = outputDirectory;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String getTestMethodName() {
        return this.testMethodName;
    }

    int getAndIncrementStepCount() {
        return this.stepCount.getAndIncrement();
    }

    public int getStepCount() {
        return this.stepCount.get();
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

