/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.springframework.util.LinkedMultiValueMap;

public class Parameters
extends LinkedMultiValueMap<String, String> {
    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(Parameters.urlEncodeUTF8((String)entry.getKey())).append('=').append(Parameters.urlEncodeUTF8(value));
            }
        }
        return sb.toString();
    }

    private static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to URL encode " + s + " using UTF-8", ex);
        }
    }
}

