/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.request.AbstractParametersSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.SnippetException;

public class RequestParametersSnippet
extends AbstractParametersSnippet {
    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors) {
        this(descriptors, null);
    }

    protected RequestParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes) {
        super("request-parameters", descriptors, attributes);
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedParameters, Set<String> missingParameters) {
        String message = "";
        if (!undocumentedParameters.isEmpty()) {
            message = message + "Request parameters with the following names were not documented: " + undocumentedParameters;
        }
        if (!missingParameters.isEmpty()) {
            if (message.length() > 0) {
                message = message + ". ";
            }
            message = message + "Request parameters with the following names were not found in the request: " + missingParameters;
        }
        throw new SnippetException(message);
    }

    @Override
    protected Set<String> extractActualParameters(Operation operation) {
        return operation.getRequest().getParameters().keySet();
    }
}

